/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.InitializeSql;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.reference.AbstractReference;
import java.util.HashMap;
import java.util.Map;

public class FKReference<T extends PersistentObject>
extends AbstractReference<T>
implements InitializeSql {
    private static final Map<String, String> queryMap = new HashMap<String, String>();
    private transient String sql;
    private boolean checkActive = false;
    private Long lastObjectID;
    private boolean deleteOnNull = false;

    public FKReference(Class<T> refType) {
        super(refType);
    }

    public FKReference<T> checkActive(boolean active) {
        this.checkActive = active;
        return this;
    }

    public static <E extends PersistentObject> FKReference<E> create(Class<E> refType) {
        return new FKReference<E>(refType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initSQL() throws Exception {
        Map<String, String> map = queryMap;
        synchronized (map) {
            String key = this.getType() + ":" + this.checkActive;
            this.sql = queryMap.get(key);
            if (this.sql == null) {
                ObjectQuery oQuery = Query.select(this.getType()).equalsParam(new PropertiedObject.Property(this.getType(), "ID"));
                if (this.checkActive) {
                    oQuery.active(this.getType());
                }
                this.sql = oQuery.toString();
                queryMap.put(key, this.sql);
            }
        }
    }

    @Override
    public T resolve() throws Exception {
        if (this.sql == null) {
            this.initSQL();
        }
        if (this.getObjectID() != null && this.getObjectID() != 0L) {
            this.reference = this.resolveViaSession(this.getObjectID(), this.getType());
            if (this.reference == null) {
                SessionI session = null;
                if (this.getOwner() != null) {
                    session = this.getOwner().getSession();
                }
                this.reference = PersistenceManager.getObject(this.getType(), this.sql, new Object[]{this.getObjectID()}, session);
                this.reference = this.registerReference((PersistentObject)this.reference);
            }
            return (T)((PersistentObject)this.reference);
        }
        return null;
    }

    @Override
    public void setObjectID(Long newObjectID) {
        if (this.deleteOnNull && this.lastObjectID == null) {
            this.lastObjectID = newObjectID;
        }
        super.setObjectID(newObjectID);
    }

    public Reference deleteOnNull(boolean delete) {
        this.deleteOnNull = delete;
        return this;
    }

    @Override
    public void saveChild() {
        if (this.deleteOnNull && this.lastObjectID != null && !this.lastObjectID.equals(this.getObjectID())) {
            Reference oldRef = (Reference)this.clone();
            oldRef.setObjectID(this.lastObjectID);
            oldRef.deleteChild();
        }
        super.saveChild();
        if (this.deleteOnNull) {
            this.lastObjectID = this.getObjectID();
        }
    }

    protected T resolveViaSession(Long objID, Class<T> clazz) {
        SessionI session;
        if (this.getOwner() != null && (session = this.getOwner().getSession()) != null) {
            return session.retrieveObject(clazz, objID);
        }
        return null;
    }

    protected T registerReference(T object) {
        SessionI session;
        if (this.getOwner() != null && (session = this.getOwner().getSession()) != null) {
            return session.registerObject(object);
        }
        return object;
    }

    protected void registerReference() {
        SessionI session;
        if (this.getOwner() != null && (session = this.getOwner().getSession()) != null) {
            this.set(session.registerObject((PersistentObject)this.get()));
        }
    }

    public String getSQL() {
        return this.sql;
    }
}

