/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.cache.remote.InvalidateableRemoteCache;
import au.com.ordermate.persistence.cache.remote.RemoteCacheSubscriptionService;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.IPAddressUtils;
import java.net.InetAddress;
import ordermate.database.hardware.Terminal;

public class PersistenceClientSetupTask
extends AbstractTask {
    boolean registerRemoteCache;
    int rmiPort;
    private String terminalType;

    public PersistenceClientSetupTask(int theRmiPort) {
        this(true, theRmiPort);
    }

    public PersistenceClientSetupTask(int theRmiPort, String terminalType) {
        this(theRmiPort);
        this.terminalType = terminalType;
    }

    public PersistenceClientSetupTask(boolean doRegisterRemoteCache, int theRmiPort) {
        this.registerRemoteCache = doRegisterRemoteCache;
        this.rmiPort = theRmiPort;
    }

    @Override
    public String getName() {
        return "Initialize Persistence";
    }

    @Override
    protected int getTotalSubTasks() {
        if (this.registerRemoteCache) {
            return 3;
        }
        return 1;
    }

    @Override
    protected void performTask() throws Exception {
        this.emitProgress();
        if (this.registerRemoteCache) {
            RemoteCacheSubscriptionService subscribeService = CacheManager.getRemoteCacheSubscribeService();
            this.emitProgress();
            if (subscribeService != null) {
                InetAddress localhost = this.getLocalHost();
                if (!SimpleRMI.isSharingObject(InvalidateableRemoteCache.RMI_OBJ_NAME)) {
                    if (this.rmiPort == 0) {
                        this.rmiPort = SimpleRMI.getSharePort();
                    }
                    SimpleRMI.shareObject(CacheManager.getInstance().getRemoteCache(InvalidateableRemoteCache.RMI_OBJ_NAME, localhost, this.rmiPort), InvalidateableRemoteCache.RMI_OBJ_NAME);
                }
                subscribeService.subscribe(InvalidateableRemoteCache.RMI_OBJ_NAME, localhost, this.rmiPort);
            }
            this.emitProgress();
        }
    }

    private InetAddress getLocalHost() throws Exception {
        if (this.terminalType != null) {
            for (InetAddress localAddress : IPAddressUtils.getLocalAddresses()) {
                Terminal terminal = Terminal.getTerminalByIp(localAddress.getHostAddress(), this.terminalType);
                if (terminal == null) continue;
                return localAddress;
            }
        }
        return InetAddress.getLocalHost();
    }
}

