/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.persistence.ComponentFactory;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public interface PersistenceDelegate
extends Serializable {
    public <T extends PersistentObjectI> List<T> getObjectList(Class<T> var1, String var2, Object[] var3, SessionI var4);

    public <T extends PersistentObjectI> T getObject(Class<T> var1, String var2, Object[] var3, SessionI var4);

    public Long save(PersistentObject var1);

    public void delete(long var1, Class<? extends PersistentObjectI> var3);

    public <T extends PersistentObject> boolean hasChanged(T var1);

    public PersistentObject createFromSnapShot(PersistentObjectSnapshot var1);

    public <T extends PersistentObject> void update(T var1, PropertiedObject.Property<?>[] var2);

    public <T extends PersistentObject> T preload(T var1);

    public <T extends PersistentObject> T preload(PersistentObjDescriptor<T> var1, List<PropertiedObject.Property<?>[]> var2);

    public <T extends PersistentObject> T getByID(long var1, Class<T> var3, SessionI var4);

    public <T extends PersistentObject> T getByID(long var1, Class<T> var3);

    public <T extends PersistentObjectI> List<T> refreshList(List<T> var1, Class<T> var2);

    public Object[][] executeQuery(String var1, Object[] var2);

    public long executeInsert(String var1, Object[] var2);

    public void executeUpdate(String var1, Object[] var2);

    public ComponentFactory createComponentFactory();

    public PersistenceMetaData createMetaData();

    public boolean isHeadOffice();

    public static class PreloadHelper {
        public static <T extends PersistentObject> T preload(PersistenceDelegate delegate, PersistentObjDescriptor<T> toPreload, List<PropertiedObject.Property<?>[]> propsToExpand) {
            T obj = delegate.getByID(toPreload.getID(), toPreload.getObjectType(), null);
            return PreloadHelper.preload(obj, propsToExpand);
        }

        public static <T extends PersistentObject> T preload(T toPreload, List<PropertiedObject.Property<?>[]> propsToExpand) {
            for (PropertiedObject.Property<?>[] path : propsToExpand) {
                PreloadHelper.preload(toPreload, path);
            }
            return toPreload;
        }

        public static <T extends PersistentObject> void preload(T obj, PropertiedObject.Property<?>[] propsToExpand) {
            if (propsToExpand.length == 0) {
                return;
            }
            Object node = obj;
            Object propValue = ((PersistentObject)node).getPropertyValue(propsToExpand[0]);
            if (propValue instanceof PersistentObject) {
                PreloadHelper.preload((PersistentObject)propValue, PreloadHelper.pop(propsToExpand));
            } else if (propValue instanceof Collection) {
                Collection propValues = (Collection)propValue;
                PropertiedObject.Property<?>[] newPath = PreloadHelper.pop(propsToExpand);
                try {
                    for (PersistentObject listItem : propValues) {
                        if (propsToExpand.length >= 1) {
                            PreloadHelper.preload(listItem, newPath);
                            continue;
                        }
                        break;
                    }
                }
                catch (ClassCastException ex) {
                    throw new RuntimeException("Attempt to navigate property path with non-leaf node that is not a persistent object, Path :" + ArrayUtils.toString(propsToExpand), ex);
                }
            }
        }

        private static PropertiedObject.Property<?>[] pop(PropertiedObject.Property<?>[] toShorten) {
            PropertiedObject.Property[] newPath = new PropertiedObject.Property[toShorten.length - 1];
            System.arraycopy(toShorten, 1, newPath, 0, toShorten.length - 1);
            return newPath;
        }
    }
}

