/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.ComponentFactory;
import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistenceDelegateRemote;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PersistentSession;
import au.com.ordermate.persistence.PlaceholderComponentFactory;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.ServerConnection;
import au.com.ordermate.persistence.ServiceLocator;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.UnsafePersistenceDelegateWrapper;
import au.com.ordermate.persistence.cache.LocalCache;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.EJB;
import ordermate.OrderMate;

public final class PersistenceManager {
    private final Set<WeakReference<LocalCache>> localCachesReferences = new HashSet<WeakReference<LocalCache>>();
    private final Set<LocalCache> localCaches = new HashSet<LocalCache>();
    private static final PersistenceManager instance = new PersistenceManager();
    private static ComponentFactory componentFactory = PlaceholderComponentFactory.INSTANCE;
    private static PersistenceMetaData persistenceMetaData;
    private static ServerConnection serverConnection;
    @EJB
    private static PersistenceDelegate persistenceDelegate;
    private Class<? extends PersistenceDelegateRemote> remoteDelegateClass = PersistenceDelegateRemote.class;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    private static ThreadLocal<PersistenceDelegate> threadLocalDelegate;

    public static PersistenceManager getInstance() {
        return instance;
    }

    public static ComponentFactory getComponentFactory() {
        return componentFactory;
    }

    public static void setComponentFactory(ComponentFactory factory) {
        ComponentFactory oldFactory = componentFactory;
        componentFactory = factory;
        if (oldFactory == PlaceholderComponentFactory.INSTANCE && componentFactory != oldFactory) {
            instance.rebuildCaches();
        }
    }

    public static PersistenceMetaData getPersistenceMetaData() {
        return persistenceMetaData;
    }

    public static void setPersistenceMetaData(PersistenceMetaData metaData) {
        persistenceMetaData = metaData;
    }

    public static ServerConnection getServerConnection() {
        return serverConnection;
    }

    public static void setServerConnection(ServerConnection connection) {
        serverConnection = connection;
    }

    public void setRemoteDelegateClass(Class<? extends PersistenceDelegateRemote> clazz) {
        if (clazz != null) {
            this.remoteDelegateClass = clazz;
        }
    }

    public static PersistenceDelegate getPersistenceDelegate() {
        if (threadLocalDelegate.get() != null) {
            return threadLocalDelegate.get();
        }
        if (persistenceDelegate == null) {
            PersistenceDelegateRemote remoteDelegate = ServiceLocator.locate(PersistenceManager.getInstance().remoteDelegateClass);
            if (remoteDelegate != null) {
                UnsafePersistenceDelegateWrapper wrappedRemote = new UnsafePersistenceDelegateWrapper(remoteDelegate);
                threadLocalDelegate.set(wrappedRemote);
                return wrappedRemote;
            }
            return null;
        }
        return persistenceDelegate;
    }

    public static void setPersistenceDelegate(PersistenceDelegate newDelegate) {
        persistenceDelegate = newDelegate;
    }

    public static <T extends PersistentObjectI, C extends PersistentObject> C reacquire(T obj) {
        if (!obj.isPersistent()) {
            throw new IllegalArgumentException("Cannot reacquire unsaved object: " + obj.getClass().getName() + " ");
        }
        Class<? extends PersistentObjectI> cls = obj.getObjectType();
        return (C)PersistenceManager.getByID(obj.getID(), cls);
    }

    public static synchronized boolean isPersistenceSetup() {
        return persistenceDelegate != null && PersistenceManager.getComponentFactory() != null && PersistenceManager.getPersistenceMetaData() != null;
    }

    public static <T extends PersistenceDelegate & ComponentFactory & ServerConnection> void initialize(T persistenceInfo) {
        PersistenceManager.setPersistenceDelegate(persistenceInfo);
        PersistenceManager.setComponentFactory(persistenceInfo);
        PersistenceManager.setServerConnection(persistenceInfo);
        PersistenceManager.setPersistenceMetaData((PersistenceMetaData)persistenceInfo);
    }

    public static void setID(PersistentObject obj, Long idNumber) {
        obj.setID(idNumber);
    }

    public static Long getID(PersistentObjectI obj) {
        return obj != null ? obj.getID() : null;
    }

    public static <T extends PersistentObject> boolean save(T toSave) {
        return PersistenceManager.doSave(toSave);
    }

    public static <T extends PersistentObject> boolean saveChild(T toSave) {
        return PersistenceManager.doSave(toSave);
    }

    private static boolean doSave(PersistentObject toSave) {
        Long id = PersistenceManager.getPersistenceDelegate().save(toSave);
        if (id != null && toSave.getID() == null) {
            toSave.setID(id);
        }
        return id != null;
    }

    public static PersistentObject createFromSnapShot(PersistentObjectSnapshot snapShot) {
        return PersistenceManager.getPersistenceDelegate().createFromSnapShot(snapShot);
    }

    public static <T extends PersistentObject> void delete(T toDelete) {
        PersistenceManager.doDelete(toDelete);
    }

    public static <T extends PersistentObject> void deleteChild(T toDelete) {
        PersistenceManager.doDelete(toDelete);
    }

    public void deleteUnmanged(PersistentObjectI toDelete) {
        PersistenceManager.doDelete(toDelete);
    }

    private static void doDelete(PersistentObjectI toDelete) {
        if (!toDelete.isPersistent()) {
            return;
        }
        PersistenceManager.getPersistenceDelegate().delete(toDelete.getID(), toDelete.getObjectType());
    }

    public void saveUnmanaged(PersistentObject toSave) {
        PersistenceManager.doSave(toSave);
    }

    public static <T extends PersistentObject> boolean hasChanged(T toCheck) {
        return PersistenceManager.getPersistenceDelegate().hasChanged(toCheck);
    }

    public static <T extends PersistentObject> boolean hasChildChanged(T toCheck) {
        return PersistenceManager.getPersistenceDelegate().hasChanged(toCheck);
    }

    public static <T extends PersistentObject> void update(T toUpdate, PropertiedObject.Property[] properties) {
        PersistenceManager.getPersistenceDelegate().update(toUpdate, properties);
    }

    public static <T extends PersistentObject> void updateChild(T toUpdate, PropertiedObject.Property[] properties) {
        PersistenceManager.getPersistenceDelegate().update(toUpdate, properties);
    }

    public static <T extends PersistentObject> T preload(T toPreload) {
        return PersistenceManager.getPersistenceDelegate().preload(toPreload);
    }

    public static <T extends PersistentObject> T preload(T toPreload, List<PropertiedObject.Property<?>[]> propertiesToExpand) {
        PersistentObjDescriptor desc = new PersistentObjDescriptor(toPreload);
        return PersistenceManager.getPersistenceDelegate().preload(desc, propertiesToExpand);
    }

    public static <T extends PersistentObject> T preload(T toPreload, PropertiedObject.Property<?> ... propertiesToExpand) {
        PersistentObjDescriptor desc = new PersistentObjDescriptor(toPreload);
        return PersistenceManager.getPersistenceDelegate().preload(desc, Collections.singletonList(propertiesToExpand));
    }

    public static <T extends PersistentObject> T getByID(long ID, Class<T> type) {
        return PersistenceManager.getByID(ID, type, null);
    }

    static <T extends PersistentObject> T getByID(long ID, Class<T> type, PersistentSession session) {
        return PersistenceManager.getPersistenceDelegate().getByID(ID, type, session);
    }

    static <T extends PersistentObjectI> T getObject(Class<T> type, String query, Object[] params, SessionI session) {
        List<T> objects = PersistenceManager.getObjectList(type, query, params, session);
        if (objects.isEmpty()) {
            return null;
        }
        return (T)((PersistentObjectI)objects.get(0));
    }

    public static <T extends PersistentObjectI> T getObject(Class<T> type, String query, Object param) {
        return PersistenceManager.getObject(type, query, PersistenceManager.getParamAsArray(param));
    }

    public static <T extends PersistentObjectI> T getObject(Class<T> type, String query) {
        return PersistenceManager.getObject(type, query, null);
    }

    public static <T extends PersistentObjectI> T getObject(Class<T> type, String query, Object[] params) {
        return PersistenceManager.getObject(type, query, params, null);
    }

    public static <T extends PersistentObjectI> List<T> getObjectList(ObjectQuerySearcher<T> searcher) {
        if (OrderMate.LOG.isDebugEnabled()) {
            OrderMate.LOG.debug("Searcher Query: " + searcher.getObjectQuery().copy());
        }
        return PersistenceManager.getObjectList(searcher.getPersistentClass(), searcher.getObjectQuery().toString(), null);
    }

    public static <T extends PersistentObjectI> List<T> getObjectList(Class<T> type, String query, Object param) {
        return PersistenceManager.getObjectList(type, query, PersistenceManager.getParamAsArray(param));
    }

    public static <T extends PersistentObjectI> List<T> getObjectList(Class<T> type, String query) {
        return PersistenceManager.getObjectList(type, query, EMPTY_OBJECT_ARRAY);
    }

    public static <T extends PersistentObjectI> List<T> getObjectList(Class<T> type, String query, Object[] params) {
        return PersistenceManager.getObjectList(type, query, params, null);
    }

    static <T extends PersistentObjectI> List<T> getObjectList(Class<T> type, String query, Object[] params, SessionI session) {
        return PersistenceManager.getPersistenceDelegate().getObjectList(type, query, params, session);
    }

    static <T extends PersistentObject> T getObjectByID(Class<T> type, long id, PersistentSession session) {
        return PersistenceManager.getPersistenceDelegate().getByID(id, type, session);
    }

    private static Object[] getParamAsArray(Object param) {
        Object[] params = param == null ? EMPTY_OBJECT_ARRAY : new Object[]{param};
        return params;
    }

    public <T extends PersistentObjectI> T getSingletonObject(Class<T> type) {
        return PersistenceManager.getObject(type, null, null);
    }

    public void registerLocalCache(LocalCache toRegister) {
        try {
            EqualityPreservingWeakReference ref = new EqualityPreservingWeakReference(toRegister);
            this.localCachesReferences.add(ref);
        }
        catch (NoClassDefFoundError ex) {
            this.localCaches.add(toRegister);
        }
    }

    private void rebuildCaches() {
        HashSet<LocalCache> allCaches = new HashSet<LocalCache>(this.localCaches);
        for (WeakReference<LocalCache> nextRef : this.localCachesReferences) {
            LocalCache nextCache;
            if (nextRef == null || (nextCache = (LocalCache)nextRef.get()) == null) continue;
            allCaches.add(nextCache);
        }
        OrderMate.LOG.info("Re-Building the caches:" + allCaches.size());
        for (LocalCache cache : allCaches) {
            if (cache instanceof LocalCacheListManager) {
                PersistentList list = ((LocalCacheListManager)cache).getListUnsafe();
                ((LocalCacheListManager)cache).setList(PlaceholderComponentFactory.INSTANCE.rebuildList(componentFactory, list));
                continue;
            }
            if (cache instanceof LocalCachedReference) {
                Reference ref = ((LocalCachedReference)cache).getReferenceUnsafe();
                ((LocalCachedReference)cache).setReferenceUnsafe(PlaceholderComponentFactory.INSTANCE.rebuildReference(componentFactory, ref));
                continue;
            }
            OrderMate.LOG.info("Cannot clear cache of class:" + cache.getClass());
        }
        this.clearLocalCaches();
    }

    public void clearLocalCaches() {
        HashSet<LocalCache> clearSet = new HashSet<LocalCache>((this.localCachesReferences.size() + this.localCaches.size()) * 2);
        Iterator<WeakReference<LocalCache>> it = this.localCachesReferences.iterator();
        while (it.hasNext()) {
            LocalCache nextCache;
            WeakReference<LocalCache> ref = it.next();
            if (ref != null && (nextCache = (LocalCache)ref.get()) != null) {
                clearSet.add(nextCache);
                continue;
            }
            it.remove();
        }
        clearSet.addAll(this.localCaches);
        for (LocalCache toClear : clearSet) {
            toClear.clearCache();
        }
    }

    public static <E extends PersistentObjectI> HashMap<Long, E> getHashMapFromObjectList(List<E> objectList) {
        if (objectList == null || objectList.size() == 0) {
            return new HashMap();
        }
        HashMap<Long, PersistentObjectI> map = new HashMap<Long, PersistentObjectI>((int)((double)objectList.size() * 1.5));
        for (PersistentObjectI obj : objectList) {
            if (obj.getID() != null) {
                map.put(obj.getID(), obj);
                continue;
            }
            throw new IllegalArgumentException("Not all persistent objects in objectList were persisted");
        }
        return map;
    }

    public static <K, V extends PersistentObject> HashMap getHashMapFromSet(Set<V> objectSet, PropertiedObject.Property<K> keyProp) {
        if (objectSet == null || objectSet.size() == 0) {
            return new HashMap();
        }
        HashMap<K, PersistentObject> map = new HashMap<K, PersistentObject>((int)((double)objectSet.size() * 1.5));
        for (PersistentObject obj : objectSet) {
            K key = obj.getPropertyValue(keyProp);
            if (key == null) {
                throw new NullPointerException("Key is null for " + obj);
            }
            if (map.containsKey(key)) {
                throw new IllegalArgumentException("Object set is not unique on key property : " + keyProp + " Object " + obj);
            }
            map.put(key, obj);
        }
        if (map.size() != objectSet.size()) {
            throw new IllegalStateException("Something has gone wrong, map does not contain all entries of the set.  Map.size: " + map.size() + " Set.size:" + objectSet.size());
        }
        return map;
    }

    public static void preloadFKListReferences(PersistentObject obj, Class[] ignoreList) {
        Field[] fields = obj.getClass().getDeclaredFields();
        ArrayList<Field> fkLists = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().isAssignableFrom(FKList.class)) continue;
            fkLists.add(fields[i]);
        }
        Iterator it = fkLists.iterator();
        try {
            while (it.hasNext()) {
                Field fkList = (Field)it.next();
                PersistentList list = null;
                try {
                    list = (PersistentList)obj.getRawFieldValue(fkList.getName());
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
                if (!(list instanceof FKList)) continue;
                ((FKList)list).preloadReferences(ignoreList);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends PersistentObjectI> boolean classSupportsQueries(Class<T> type) {
        return PersistenceManager.getPersistenceMetaData().classSupportsQueries(type);
    }

    public static <T extends PersistentObjectI> List<T> refreshList(List<T> persistentObjects, Class<T> objType) {
        return PersistenceManager.getPersistenceDelegate().refreshList(persistentObjects, objType);
    }

    public static Logger getLogger() {
        return Logger.getLogger(PersistenceManager.class.getName());
    }

    public static void setLocalState(PersistenceDelegate persistence) {
        threadLocalDelegate.set(persistence);
    }

    public static PersistenceDelegate getLocalState() {
        return threadLocalDelegate.get();
    }

    public static void removeLocalState() {
        threadLocalDelegate.remove();
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        threadLocalDelegate = new ThreadLocal();
    }

    private static class EqualityPreservingWeakReference
    extends WeakReference<LocalCache> {
        public EqualityPreservingWeakReference(LocalCache arg0) {
            super(arg0);
        }

        public boolean equals(Object ref) {
            if (ref == null || !(ref instanceof WeakReference)) {
                return false;
            }
            WeakReference otherRef = (WeakReference)ref;
            if (super.equals(otherRef)) {
                return true;
            }
            Object referent = this.get();
            if (referent == null) {
                return false;
            }
            return referent.equals(otherRef.get());
        }

        public int hashCode() {
            Object referent = this.get();
            if (referent != null) {
                return referent.hashCode();
            }
            return 0;
        }
    }
}

