/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@AccessType(value="property")
@MappedSuperclass
public abstract class PersistentDisplayableObject
extends PersistentObject
implements Displayable {
    private static final long serialVersionUID = 1L;
    public static final Props Properties = new Props();
    private Color backgroundColor;
    private Color foregroundColor;
    private String icon = "";
    private String label = "No Label Set";
    protected String labelFormat = "";

    public PersistentDisplayableObject() {
    }

    @Transient
    protected String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(String newLabelFormat) {
        boolean hasFormatingArg = false;
        for (int i = 0; i < newLabelFormat.length(); ++i) {
            if (newLabelFormat.charAt(i) != '%' || i != 0 && newLabelFormat.charAt(i - 1) == '%' || i + 1 >= newLabelFormat.length() || newLabelFormat.charAt(i + 1) == '%') continue;
            if (hasFormatingArg || i + 1 < newLabelFormat.length() && newLabelFormat.charAt(i + 1) != 's') {
                throw new IllegalArgumentException("Invalid format string, should only have one format specifier: " + newLabelFormat);
            }
            hasFormatingArg = true;
        }
        this.labelFormat = newLabelFormat;
    }

    protected PersistentDisplayableObject(PersistentDisplayableObject toCopy) {
        this.backgroundColor = toCopy.backgroundColor;
        this.foregroundColor = toCopy.foregroundColor;
        this.label = toCopy.label;
        this.icon = toCopy.icon;
    }

    public void setBackgroundColor(Color newBackgroundColor) {
        this.backgroundColor = newBackgroundColor;
    }

    public void setForegroundColor(Color newForegroundColor) {
        this.foregroundColor = newForegroundColor;
    }

    public void setIcon(String newIcon) {
        this.icon = newIcon;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel != null && newLabel.length() > 99 ? newLabel.substring(0, 99) : newLabel;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    @Transient
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Column(name="name")
    public String getLabel() {
        if (this.labelFormat.equals("")) {
            return this.label;
        }
        return String.format(this.getLabelFormat(), this.label);
    }

    @Transient
    public String getLabelNoFormat() {
        return this.label;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> ICON;
        public PropertiedObject.Property<Color> BACKGROUND_COLOR;
        public PropertiedObject.Property<Color> FOREGROUND_COLOR;
    }
}

