/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.persistence.Displayable;
import java.awt.Color;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class PersistentEnumeration
implements Displayable,
Serializable {
    private final String description;
    private final String label;

    protected PersistentEnumeration(String desc) {
        this.description = desc;
        this.label = desc;
    }

    protected PersistentEnumeration(String desc, String displayableLabel) {
        this.description = desc;
        this.label = displayableLabel;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        return this.description.equals(((PersistentEnumeration)other).description);
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public final String toString() {
        return this.description;
    }

    public static <T> Map<String, T> buildRegister(T ... types) {
        UnmodifiableMapBuilder<T> builder = new UnmodifiableMapBuilder<T>();
        for (int i = 0; i < types.length; ++i) {
            builder.put(types[i]);
        }
        return builder.getMap();
    }

    protected static UnmodifiableMapBuilder getRegisterBuilder() {
        return new UnmodifiableMapBuilder();
    }

    @Override
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    public Color getForegroundColor() {
        return null;
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    protected static class UnmodifiableMapBuilder<T> {
        private Map<String, T> map = new LinkedHashMap<String, T>();

        public UnmodifiableMapBuilder put(T unit) {
            this.map.put(unit.toString(), unit);
            return this;
        }

        public Map<String, T> getMap() {
            Map<String, T> retVal = Collections.unmodifiableMap(new LinkedHashMap<String, T>(this.map));
            this.map = null;
            return retVal;
        }
    }
}

