/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.SuperSaveable;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import ordermate.OrderMate;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.GenericGenerator;

@MappedSuperclass
@AccessType(value="property")
public abstract class PersistentObject
implements Serializable,
PersistentObjectI,
PropertiedObject {
    protected static final long serialVersionUID = 3L;
    public static final Props Properties = new Props();
    private transient SessionI session;
    private PersistentObjectSnapshot lastSavedSnapshot;
    private volatile Long ID;
    private int version;
    private Long storeId = 0L;
    private Long modCount = 0L;
    private static final Map<Class<? extends PersistentObject>, List<PropertiedObject.Property>> getSnapshotFieldsCache = new HashMap<Class<? extends PersistentObject>, List<PropertiedObject.Property>>();

    protected final <T extends PersistentObjectI> PersistentList<T> createList(PropertiedObject.Property<T> property) {
        PersistentList newList = PersistenceManager.getComponentFactory().createList(property);
        newList.setOwner(this);
        return newList;
    }

    protected final <T extends PersistentObjectI & SuperSaveable> PersistentWriteableList<T> createWriteableList(PropertiedObject.Property<T> property) {
        PersistentWriteableList newList = PersistenceManager.getComponentFactory().createWriteableList(property);
        newList.setOwner(this);
        return newList;
    }

    protected final <T extends PersistentObject> Reference<T> createReference(PropertiedObject.Property<T> property) {
        Reference<T> newReference = PersistenceManager.getComponentFactory().createReference(property);
        newReference.setOwner(this);
        return newReference;
    }

    public void init() {
        if (PersistenceManager.getPersistenceMetaData().usesSnapshot()) {
            this.setLastSavedSnapshot(this.getSnapshot());
        }
    }

    @Override
    @Id
    @GeneratedValue(generator="myGenerator")
    @GenericGenerator(name="myGenerator", strategy="au.com.ordermate.persistence.hibernate.CustomizedIdGenerator")
    @Column(name="ID")
    public Long getID() {
        return this.ID;
    }

    public synchronized long intID() {
        return this.getID() != null ? this.getID() : 0L;
    }

    protected synchronized void setID(Long newID) {
        if (Config.isDebuging() && this.isPersistent() && newID != null && !newID.equals(this.ID)) {
            throw new IllegalStateException(this + " already has ID of " + this.getID() + ", cannot change id to " + newID);
        }
        this.ID = newID;
    }

    @Transient
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int newVersion) {
        this.version = newVersion;
    }

    @Column(name="store_id")
    public Long getStoreId() {
        return this.storeId;
    }

    public void setStoreId(Long id) {
        this.storeId = id;
    }

    @Deprecated
    protected final synchronized void setID_WorkAround(Long newID) {
        this.setID(newID);
    }

    protected final Object getRawFieldValue(String field) throws Exception {
        Class<?> propsClass = this.getProperties().getClass();
        while (!propsClass.equals(Object.class)) {
            if (PersistentObject.hasField(field, propsClass)) {
                return PersistentObject.getField(this.getClass(), field).get(this);
            }
            propsClass = propsClass.getSuperclass();
        }
        throw new NoSuchFieldException(this.getClass() + " does not have field " + field + ".  Did you forget to include getRawFieldValue()?");
    }

    public static final boolean hasField(String field, Class propsClass) {
        return PropertiedObject.PropsHelper.hasField(field, propsClass);
    }

    public static final Field getField(Class clazz, String field) throws NoSuchFieldException {
        return PropertiedObject.PropsHelper.getField(clazz, field);
    }

    @Transient
    public PersistentObjectSnapshot getSnapshot() {
        Class<?> snapshotClass = this.getClass();
        try {
            List<PropertiedObject.Property> properties = PersistentObject.getSnapshotFields(snapshotClass);
            PersistentObjectSnapshot snapshot = new PersistentObjectSnapshot(snapshotClass, properties.size());
            for (PropertiedObject.Property property : properties) {
                Object value = property.getName().equals(PersistentObject.Properties.ID.getName()) ? this.ID : this.getRawFieldValue(property.getName());
                if (value instanceof Reference) {
                    Reference refVal = (Reference)value;
                    snapshot.add(property, refVal.getObjectID());
                    continue;
                }
                if (value instanceof List) continue;
                snapshot.add(property, value);
            }
            return snapshot;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error generating snapshot ", (Throwable)e);
            throw new RuntimeException("Cannot create snapshot " + e.getMessage(), e);
        }
    }

    @Override
    @Transient
    public Props getProperties() {
        return (Props)PropertiedObject.PropsHelper.getProperties(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<PropertiedObject.Property> getSnapshotFields(Class<? extends PersistentObject> snapshotClass) throws NoSuchFieldException, IllegalAccessException {
        Map<Class<? extends PersistentObject>, List<PropertiedObject.Property>> map = getSnapshotFieldsCache;
        synchronized (map) {
            if (getSnapshotFieldsCache.containsKey(snapshotClass)) {
                return getSnapshotFieldsCache.get(snapshotClass);
            }
            LinkedList<PropertiedObject.Property> properties = new LinkedList<PropertiedObject.Property>();
            PropertiedObject.Props propsInstance = PropertiedObject.PropsHelper.getProperties(snapshotClass);
            Class<?> propertiesClass = propsInstance.getClass();
            while (!propertiesClass.equals(Object.class)) {
                Field[] fieldList = propertiesClass.getDeclaredFields();
                for (int i = 0; i < fieldList.length; ++i) {
                    Field currentField = fieldList[i];
                    int modifiers = currentField.getModifiers();
                    if (!Modifier.isPublic(modifiers) || !currentField.getType().isAssignableFrom(PropertiedObject.Property.class)) continue;
                    properties.add((PropertiedObject.Property)currentField.get(propsInstance));
                }
                propertiesClass = propertiesClass.getSuperclass();
            }
            getSnapshotFieldsCache.put(snapshotClass, properties);
            return properties;
        }
    }

    @Override
    @Transient
    public boolean isPersistent() {
        return this.ID != null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        boolean equal = this.getClass().isAssignableFrom(other.getClass());
        if (equal) {
            PersistentObjectI persistantOther = (PersistentObjectI)other;
            equal = this.isPersistent() && persistantOther.isPersistent() ? persistantOther.getID().equals(this.getID()) : super.equals(persistantOther);
        }
        return equal;
    }

    public int hashCode() {
        if (this.isPersistent()) {
            int hash = 1;
            hash = 31 * hash + this.getID().hashCode();
            hash = 31 * hash + this.getClass().hashCode();
            return hash;
        }
        return super.hashCode();
    }

    public String toString() {
        String name = this.getClass().getName() + "[" + this.getID() + "]";
        return name;
    }

    @Transient
    public Class<? extends PersistentObject> getObjectType() {
        return this.getClass();
    }

    public void setLastSavedSnapshot(PersistentObjectSnapshot snapshot) {
        this.lastSavedSnapshot = snapshot;
    }

    @Transient
    public PersistentObjectSnapshot getLastSavedSnapshot() {
        return this.lastSavedSnapshot;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public void setPropertyValue(PropertiedObject.Property prop, Object value) {
        PropertiedObject.PropsHelper.setPropertyValue(this, prop, value);
    }

    @Transient
    final SessionI getSession() {
        return this.session;
    }

    final void setSession(SessionI newSession) {
        if (this.session != null && this.session != newSession) {
            throw new IllegalStateException("A PersistentObject cannot be passed between sessions:" + this.getClass().getSimpleName() + " session1: " + this.session + " session2" + newSession);
        }
        this.session = newSession;
        for (PropertiedObject.Property prop : this.getProperties()) {
            try {
                FKReference reference;
                Field field = PersistentObject.getField(this.getClass(), prop.getName());
                if (FKList.class.isAssignableFrom(field.getType())) {
                    FKList list = (FKList)field.get(this);
                    if (!list.isExpanded()) continue;
                    list.registerToSession();
                    continue;
                }
                if (!FKReference.class.isAssignableFrom(field.getType()) || !(reference = (FKReference)field.get(this)).isExpanded()) continue;
                reference.registerReference();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("No such field for property, should not happen with persistentObjects that are valid", (Throwable)ex);
            }
        }
    }

    public final PersistentObjDescriptor describe() {
        return new PersistentObjDescriptor(this);
    }

    @Column(name="mod_count")
    public Long getModCount() {
        return this.modCount;
    }

    protected void setModCount(Long modCount) {
        this.modCount = modCount;
    }

    public static class DerivedProperty<T>
    extends PropertiedObject.Property<T> {
        public DerivedProperty(Class<? extends PersistentObject> newOwner, String newPropertyName) {
            super(newOwner, newPropertyName);
        }

        @Override
        public Class<T> getType() {
            try {
                return this.getTypeFromMethod();
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Error getting property type for " + this, ex);
            }
            catch (SecurityException ex2) {
                throw new RuntimeException("Error getting property type for " + this, ex2);
            }
        }
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<Long> ID;
        public PropertiedObject.Property<Integer> VERSION;
        public PropertiedObject.Property<Integer> STORE_ID;
        public PropertiedObject.Property<Long> MOD_COUNT;
    }
}

