/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PersistentObjectSnapshot<T extends PersistentObject>
implements Serializable,
PersistentObjectI {
    private final Class<T> snapshotType;
    private final Map<PropertiedObject.Property<?>, Object> properties;

    public PersistentObjectSnapshot(Class<T> newSnapShotType, int numProps) {
        this.properties = new HashMap((int)((double)numProps * 1.334));
        this.snapshotType = newSnapShotType;
    }

    public <V> PersistentObjectSnapshot add(PropertiedObject.Property<V> property, V value) {
        this.properties.put(property, value);
        return this;
    }

    public <V> V get(PropertiedObject.Property<V> property) {
        return (V)this.properties.get(property);
    }

    public boolean contains(PropertiedObject.Property<?> property) {
        return this.properties.containsKey(property);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>(this.properties.size());
        for (PropertiedObject.Property<?> prop : this.properties.keySet()) {
            names.add(prop.getName());
        }
        return names;
    }

    public Set<PropertiedObject.Property<?>> getProperties() {
        return this.properties.keySet();
    }

    @Override
    public Long getID() {
        return this.get(PersistentObject.Properties.ID);
    }

    @Override
    public boolean isPersistent() {
        return this.getID() != null;
    }

    public Class<T> getObjectType() {
        return this.snapshotType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PersistentObjectSnapshot)) {
            return false;
        }
        PersistentObjectSnapshot snapshot = (PersistentObjectSnapshot)object;
        if (!this.snapshotType.equals(snapshot.getObjectType())) {
            return false;
        }
        if (this.getID() != null && !this.getID().equals(snapshot.getID())) {
            return false;
        }
        for (Map.Entry<PropertiedObject.Property<?>, Object> entry : this.properties.entrySet()) {
            Object value = entry.getValue();
            Object snapshotValue = snapshot.properties.get(entry.getKey());
            if (value != null && !value.equals(snapshotValue)) {
                return false;
            }
            if (value != null || snapshotValue == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 31 * this.snapshotType.hashCode();
        for (Map.Entry<PropertiedObject.Property<?>, Object> entry : this.properties.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            hash *= value.hashCode();
        }
        return hash;
    }

    public Integer getVersion() {
        return this.get(PersistentObject.Properties.VERSION);
    }

    public Integer incrementVersion() {
        int version = this.get(PersistentObject.Properties.VERSION) + 1;
        Integer retValue = version;
        this.add(PersistentObject.Properties.VERSION, retValue);
        return retValue;
    }
}

