/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.persistence.PersistentObjectSnapshot;
import ordermate.database.diff.VersionDiff;

public class PersistentObjectSnapshotDiff {
    public static final PersistentObjectSnapshotDiff ALL_DONE = new PersistentObjectSnapshotDiff(null, null, null);
    private final PersistentObjectSnapshot oldSnapshot;
    private final PersistentObjectSnapshot newSnapshot;
    private final VersionDiff.ChangeType changeType;

    public PersistentObjectSnapshotDiff(PersistentObjectSnapshot lastSavedSnapshot, PersistentObjectSnapshot changedSnapshot, VersionDiff.ChangeType persistentChangeType) {
        this.oldSnapshot = lastSavedSnapshot;
        this.newSnapshot = changedSnapshot;
        this.changeType = persistentChangeType;
    }

    public PersistentObjectSnapshot getOldSnapshot() {
        return this.oldSnapshot;
    }

    public PersistentObjectSnapshot getNewSnapshot() {
        return this.newSnapshot;
    }

    public VersionDiff.ChangeType getChangeType() {
        return this.changeType;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.oldSnapshot != null) {
            text.append("Object type: " + this.getOldSnapshotClazz());
            text.append(" , ");
            text.append("ID: " + this.oldSnapshot.getID());
        } else if (this.newSnapshot != null) {
            text.append("Object type: " + this.getNewSnapshotClazz());
            text.append(" , ");
            text.append("ID: " + this.newSnapshot.getID());
        }
        text.append(" , ");
        text.append("DB Change: ");
        text.append(this.changeType != null ? this.changeType.toString() : "null");
        return text.toString();
    }

    public Class getClassType() {
        if (this.oldSnapshot != null) {
            return this.getOldSnapshotClazz();
        }
        if (this.newSnapshot != null) {
            return this.getNewSnapshotClazz();
        }
        return null;
    }

    private Class getOldSnapshotClazz() {
        return this.oldSnapshot.getObjectType();
    }

    private Class getNewSnapshotClazz() {
        return this.newSnapshot.getObjectType();
    }
}

