/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.SessionI;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;

public class PersistentSession
implements SessionI,
Serializable {
    private final Map<Class<? extends PersistentObject>, Map<Long, ? extends PersistentObject>> classMap = new HashMap<Class<? extends PersistentObject>, Map<Long, ? extends PersistentObject>>();

    public PersistentSession(List<? extends PersistentObject> objects) {
        if (!objects.isEmpty()) {
            this.registerObjects(objects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PersistentObject> T registerObject(T pObj) {
        if (pObj == null) {
            return pObj;
        }
        Class<?> clazz = pObj.getClass();
        Map<Long, PersistentObject> instanceMap = this.classMap.get(clazz);
        if (instanceMap == null) {
            instanceMap = this.getInstanceMap(clazz);
        }
        pObj.setSession(this);
        Long id = pObj.getID();
        if (id == null) {
            return pObj;
        }
        Map<Long, PersistentObject> map = instanceMap;
        synchronized (map) {
            PersistentObject current = instanceMap.get(id);
            if (current != null) {
                return (T)current;
            }
            instanceMap.put(id, pObj);
            return pObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PersistentObject> Map<Long, T> getInstanceMap(Class<T> clazz) {
        Map<Class<? extends PersistentObject>, Map<Long, ? extends PersistentObject>> map = this.classMap;
        synchronized (map) {
            if (!this.classMap.containsKey(clazz)) {
                this.classMap.put(clazz, (Map<Long, ? extends PersistentObject>)new ReferenceMap(0, 2, true));
            }
        }
        return this.classMap.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PersistentObject> T retrieveObject(Class<T> clazz, long id) {
        Long longID = id;
        PersistentObject object = null;
        Map<Long, ? extends PersistentObject> instanceMap = this.classMap.get(clazz);
        if (instanceMap != null) {
            Map<Long, ? extends PersistentObject> map = instanceMap;
            synchronized (map) {
                object = instanceMap.get(longID);
            }
        }
        return (T)object;
    }

    @Override
    public <T extends PersistentObject> void registerObjects(List<T> objects) {
        for (int i = 0; i < objects.size(); ++i) {
            PersistentObject nextObject = (PersistentObject)objects.get(i);
            PersistentObject myObject = this.registerObject(nextObject);
            objects.set(i, myObject);
        }
    }
}

