/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.annotations.AccessType;

@MappedSuperclass
@AccessType(value="property")
public abstract class PersistentSummaryObject
extends PersistentObject {
    public static final Props Properties = new Props();
    @Transient
    private Object[] parameters = new Object[0];

    protected PersistentSummaryObject() {
    }

    protected void setParameters(Object[] params) {
        this.parameters = params;
    }

    protected void addParameter(Object param) {
        this.parameters = ArrayUtils.add((Object[])this.parameters, (Object)param);
    }

    @Transient
    protected Object[] getParams() {
        return this.parameters;
    }

    @Transient
    protected int getParamCount() {
        return this.parameters.length;
    }

    @Transient
    protected String getParamsQueryString() {
        if (this.parameters.length == 0) {
            return " (NULL) ";
        }
        String text = " (";
        boolean first = true;
        for (int i = 0; i < this.parameters.length; ++i) {
            if (first) {
                first = false;
            } else {
                text = text + ",";
            }
            text = text + this.parameters[i].toString();
        }
        text = text + ") ";
        return text;
    }

    protected void clearParameters() {
        this.setParameters(new Object[0]);
    }

    public static class Props
    extends PersistentObject.Props {
        private Map fieldDisplayLabels = new HashMap();

        protected void initFieldLabels() {
        }

        protected Props() {
            this.initFieldLabels();
        }

        public String getFieldLabel(PropertiedObject.Property prop) {
            return (String)this.fieldDisplayLabels.get(prop);
        }

        public void addFieldLabel(PropertiedObject.Property prop, String fieldLabel) {
            this.fieldDisplayLabels.put(prop, fieldLabel);
        }
    }
}

