/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.ComponentFactory;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import ordermate.OrderMate;

public class PlaceholderComponentFactory
implements ComponentFactory {
    private static String EXCEPTION_MSG = "Product of null factory does not support operations.  Ensure that PersistenceManager has a component factory initialized";
    public static final PlaceholderComponentFactory INSTANCE = new PlaceholderComponentFactory();

    private static String getExceptionMsg() {
        return EXCEPTION_MSG;
    }

    private PlaceholderComponentFactory() {
    }

    @Override
    public PersistentList createList(PropertiedObject.Property property) {
        PlaceholderComponentFactory.getLogger().finest("Creating a NullPersistentList");
        return new PlaceholderPersistentList(RefType.LIST, property);
    }

    public Reference createReference(PropertiedObject.Property property) {
        PlaceholderComponentFactory.getLogger().finest("Creating a NullReference");
        return new PlaceholderReference(RefType.REF, property);
    }

    @Override
    public PersistentWriteableList createWriteableList(PropertiedObject.Property prop) {
        PlaceholderComponentFactory.getLogger().finest("Creating a NullWriteableList");
        return new PlaceholderPersistentList(RefType.WRITEABLE_LIST, prop);
    }

    @Override
    public <T extends PersistentObject> PersistentList<T> createQueryList(Class<T> objectType, ObjectQuery query) {
        PlaceholderComponentFactory.getLogger().finest("Creating a NullQueryList");
        return new PlaceholderPersistentList(RefType.QUERY_LIST, objectType, query);
    }

    @Override
    public <T extends PersistentObject> PersistentList<T> createQueryList(Class<T> objectType, String query) {
        PlaceholderComponentFactory.getLogger().finest("Creating a NullQueryList");
        return new PlaceholderPersistentList(RefType.QUERY_LIST, objectType, query);
    }

    public Reference rebuildReference(ComponentFactory factory, Reference reference) {
        if (reference instanceof PlaceholderReference) {
            return factory.createReference(((PlaceholderReference)reference).property);
        }
        return reference;
    }

    public PersistentList rebuildList(ComponentFactory factory, PersistentList list) {
        if (factory == this) {
            OrderMate.LOG.warn("Using Null Component Factory to rebuild lists... not a good idea.");
            return list;
        }
        if (!(list instanceof PlaceholderPersistentList)) {
            OrderMate.LOG.warn("Not a null persistent list, cannot rebuild it");
            return list;
        }
        PlaceholderPersistentList nullList = (PlaceholderPersistentList)list;
        RefType type = nullList.type;
        if (RefType.LIST.equals((Object)type)) {
            return factory.createList(nullList.property);
        }
        if (RefType.QUERY_LIST.equals((Object)type)) {
            if (nullList.oQuery != null) {
                return factory.createQueryList(nullList.clazz, nullList.oQuery);
            }
            return factory.createQueryList(nullList.clazz, nullList.sQuery);
        }
        if (RefType.WRITEABLE_LIST.equals((Object)type)) {
            return factory.createWriteableList(nullList.property);
        }
        OrderMate.LOG.error("Couldn't create a new list for given type:" + (Object)((Object)type));
        return nullList;
    }

    public static Logger getLogger() {
        return Logger.getLogger(PlaceholderComponentFactory.class.getName());
    }

    private static class PlaceholderPersistentList
    implements PersistentWriteableList {
        private RefType type;
        private Class clazz;
        private ObjectQuery oQuery;
        private String sQuery;
        private PropertiedObject.Property property;

        public PlaceholderPersistentList(RefType type, Class clazzType, String query) {
            this.clazz = clazzType;
            this.type = type;
            this.sQuery = query;
        }

        public PlaceholderPersistentList(RefType type, Class clazzType, ObjectQuery query) {
            this.clazz = clazzType;
            this.type = type;
            this.oQuery = query;
        }

        public PlaceholderPersistentList(RefType type, PropertiedObject.Property property) {
            this.type = type;
            this.property = property;
        }

        public List getLocalObjects() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void collapse() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void collapseUnsafe() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public List getUnmodifiable() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean isExpanded() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void set(List list) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void setOwner(PersistentObject owner) {
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void add(int index, Object element) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public PersistentWriteableList clone() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Object get(int index) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public ListIterator listIterator() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public ListIterator listIterator(int index) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Object remove(int index) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Object set(int index, Object element) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Object[] toArray(Object[] a) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void initSQL() throws Exception {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void deleteChild() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean hasChildChanged() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void saveChild() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Long getID() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Class<? extends PersistentObjectI> getObjectType() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean isPersistent() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void prepareForSave(SaveContext context) {
        }
    }

    private static class PlaceholderReference
    implements Reference {
        private RefType type;
        private PropertiedObject.Property property;

        public PlaceholderReference(RefType ref, PropertiedObject.Property property) {
            this.type = ref;
            this.property = property;
        }

        @Override
        public boolean belongsToOwner() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void collapse() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        public PersistentObjectI get() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Long getObjectID() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        public Class getType() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean isExpanded() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean isNull() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        public void set(PersistentObjectI value) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void setObjectID(Long newObjectID) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void setOwner(PersistentObject owner) {
        }

        @Override
        public void deleteChild() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean hasChildChanged() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void saveChild() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Long getID() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public Class<? extends PersistentObjectI> getObjectType() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public boolean isPersistent() {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void prepareForSave(SaveContext context) {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }

        @Override
        public void initSQL() throws Exception {
            throw new UnsupportedOperationException(PlaceholderComponentFactory.getExceptionMsg());
        }
    }

    private static enum RefType {
        REF,
        LIST,
        QUERY_LIST,
        WRITEABLE_LIST;

    }
}

