/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.reflect.FieldUtils;
import au.com.ordermate.reflect.ReflectUtils;
import au.com.ordermate.util.LangUtils;
import au.com.ordermate.util.maps.ITypeMap;
import au.com.ordermate.util.maps.TypeHashMap;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import ordermate.OrderMate;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public interface PropertiedObject {
    public Props getProperties();

    public <T> T getPropertyValue(Property<T> var1);

    public static final class PropsHelper {
        private static final ITypeMap hasFieldCache = new TypeHashMap();
        private static final Map<Class<? extends PropertiedObject>, Props> propertiesCache = new HashMap<Class<? extends PropertiedObject>, Props>();

        private PropsHelper() {
        }

        public static <E> E getPropertyValue(PropertiedObject owner, Property<E> prop) {
            if (Config.isDebuging() && !prop.getOwner().isAssignableFrom(owner.getClass())) {
                throw new IllegalArgumentException("Property must belong to :" + owner.getClass() + " or one of its parents,  instead belongs to " + prop.getOwner());
            }
            try {
                return (E)prop.getMethod().invoke((Object)owner, (Object[])null);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Should not occur when using a persistent property " + prop, ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Should not occur when using a persistent property " + prop, ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Should not occur when using a persistent property " + prop, ex);
            }
            catch (Exception ex) {
                try {
                    Method proxyMethod = owner.getClass().getMethod(prop.getMethod().getName(), new Class[0]);
                    return (E)proxyMethod.invoke((Object)owner, (Object[])null);
                }
                catch (Exception ex2) {
                    OrderMate.LOG.info("General Error getting property value:" + owner.getClass() + " Prop belongs to " + prop.getOwner());
                    throw new RuntimeException("Error in getting propertied object value " + owner + " " + prop, ex2);
                }
            }
        }

        public static void setPropertyValue(Object owner, Property prop, Object value) {
            if (Config.isDebuging() && !prop.getOwner().isAssignableFrom(owner.getClass())) {
                throw new IllegalArgumentException("Property: " + prop + " does not belong to: " + owner.getClass() + " or one of it's superclasses");
            }
            try {
                PropertyUtils.setProperty((Object)owner, (String)prop.getName(), (Object)value);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("NoSuchMethodException should not occur when using a persistent property " + prop.getName() + " for " + owner.getClass(), ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("InvocationTargetException should not occur when using a persistent property " + prop.getName() + " for " + owner.getClass(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("IllegalAccessException should not occur when using a persistent property " + prop.getName() + " for " + owner.getClass(), ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("IllegalArgumentException should not occur when using a persistent property " + prop.getName() + " for " + owner.getClass(), ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final boolean hasField(String property, Class propsClass) {
            ITypeMap iTypeMap = hasFieldCache;
            synchronized (iTypeMap) {
                String key = property;
                Boolean result = (Boolean)hasFieldCache.get(propsClass, key);
                if (result != null) {
                    return result;
                }
                Class ownerClass = propsClass.getDeclaringClass();
                if (ownerClass == null) {
                    ownerClass = LangUtils.getDeclaringClass(propsClass);
                }
                Field[] fields = ownerClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    int modifiers = field.getModifiers();
                    if (!field.getName().equals(property) || !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers)) continue;
                    hasFieldCache.put(propsClass, key, Boolean.TRUE);
                    return true;
                }
                hasFieldCache.put(propsClass, key, Boolean.FALSE);
                return false;
            }
        }

        public static final Field getField(Class owner, String property) throws NoSuchFieldException {
            try {
                return FieldUtils.getField(owner, property);
            }
            catch (Exception e) {
                throw new NoSuchFieldException("PersistentObject invalid : " + owner.getSimpleName() + " does not have field " + property);
            }
        }

        public static Props getProperties(Class<? extends PropertiedObject> objClass) {
            try {
                Props props = propertiesCache.get(objClass);
                if (props != null) {
                    return props;
                }
                try {
                    props = (Props)objClass.getDeclaredField("Properties").get(null);
                }
                catch (NoSuchFieldException ex) {
                    props = (Props)objClass.getField("Properties").get(null);
                }
                propertiesCache.put(objClass, props);
                return props;
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalStateException("PersistentObject invalid : " + objClass.getSimpleName() + " does not declare a public static Properties field");
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("PersistentObject invalid : " + objClass.getSimpleName() + " does not declare a public static Properties field");
            }
        }

        public static <T extends PropertiedObject, P extends T> void copyProperties(Collection<Property> props, T copyFrom, P copyTo) {
            for (Property prop : props) {
                PropsHelper.setPropertyValue(copyTo, prop, PropsHelper.getPropertyValue(copyFrom, prop));
            }
        }
    }

    public static class Property<T>
    implements Serializable,
    Cloneable,
    PropertyAccessor<T> {
        private final String name;
        private String prettyName;
        private final Class<? extends PropertiedObject> owner;
        private transient Class<T> objectType;
        private transient Method accessorMethod;
        private transient Boolean isList;
        private transient Boolean isReference;
        private transient String toStringCache;

        public Property(Class<? extends PropertiedObject> newOwner, String newPropertyName) {
            this.name = newPropertyName.intern();
            this.owner = newOwner;
        }

        public Property(Class<? extends PropertiedObject> newOwner, Property propToCopy) {
            this(newOwner, propToCopy.name);
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends PropertiedObject> getOwner() {
            return this.owner;
        }

        public Class<T> getType() {
            try {
                return PropsHelper.getField(this.owner, this.name).getType();
            }
            catch (NoSuchFieldException e) {
                try {
                    return this.getTypeFromMethod();
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException("Error getting property type", e);
                }
                catch (SecurityException ex2) {
                    throw new RuntimeException("Error getting property type", e);
                }
            }
        }

        private Class<T> findObjectType() {
            try {
                return this.getTypeFromMethod();
            }
            catch (NoSuchMethodException e) {
                try {
                    return this.getObjectType(this.getOwner().newInstance());
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(this + " Could not instantiate : " + this.getOwner(), ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Could not instantiate: " + this.getOwner(), ex);
                }
            }
        }

        public boolean isReference() {
            if (this.isReference == null) {
                Class<T> type = this.getType();
                this.isReference = Reference.class.isAssignableFrom(type);
            }
            return this.isReference;
        }

        public boolean isList() {
            if (this.isList == null) {
                Class<T> type = this.getType();
                this.isList = List.class.isAssignableFrom(type);
            }
            return this.isList;
        }

        public boolean isCollection() {
            return Collection.class.isAssignableFrom(this.getType());
        }

        public Class<T> getObjectType(PropertiedObject instance) {
            try {
                Class<T> type = this.getType();
                if (Reference.class.isAssignableFrom(type)) {
                    Field field = PropsHelper.getField(this.owner, this.name);
                    field.setAccessible(true);
                    Reference ref = (Reference)field.get(instance);
                    field.setAccessible(false);
                    return ref.getObjectType();
                }
                return type;
            }
            catch (IllegalAccessException ex2) {
                throw new RuntimeException("Error getting property type", ex2);
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException("Error getting property type", ex);
            }
        }

        public Class<T> getObjectTypeFromMethod() {
            try {
                return this.getTypeFromMethod();
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(this.name + " has no accessor method in class " + this.owner, ex);
            }
        }

        public Class<T> getObjectType() {
            if (this.objectType == null) {
                this.objectType = this.findObjectType();
            }
            return this.objectType;
        }

        public Class getActualObjectType() {
            try {
                ParameterizedType pt;
                Type[] actualTypeArgs;
                Type type;
                Field field = PropsHelper.getField(this.owner, this.name);
                if (field != null && (type = field.getGenericType()) instanceof ParameterizedType && (actualTypeArgs = (pt = (ParameterizedType)type).getActualTypeArguments()) != null && actualTypeArgs.length > 0) {
                    return (Class)actualTypeArgs[0];
                }
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException("Error getting property type", ex);
            }
            return this.getObjectType();
        }

        protected Class<T> getTypeFromMethod() throws NoSuchMethodException, SecurityException {
            return this.getMethod().getReturnType();
        }

        public Method getMethod() throws NoSuchMethodException {
            if (this.accessorMethod != null) {
                return this.accessorMethod;
            }
            String methodName = this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
            try {
                this.accessorMethod = this.owner.getMethod("get" + methodName, new Class[0]);
                this.accessorMethod.setAccessible(true);
                return this.accessorMethod;
            }
            catch (NoSuchMethodException ex) {
                try {
                    this.accessorMethod = this.owner.getMethod("is" + methodName, new Class[0]);
                    this.accessorMethod.setAccessible(true);
                    return this.accessorMethod;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Class<? extends PropertiedObject> classToCheck = this.owner;
                    while (true) {
                        try {
                            this.accessorMethod = this.getMethod(classToCheck);
                            return this.accessorMethod;
                        }
                        catch (NoSuchMethodException ex2) {
                            if (!(classToCheck = classToCheck.getSuperclass()).equals(Object.class)) continue;
                            throw ex2;
                        }
                        break;
                    }
                }
            }
        }

        private Method getMethod(Class<?> declaringClass) throws NoSuchMethodException {
            String methodName = this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
            try {
                Method method = declaringClass.getDeclaredMethod("get" + methodName, new Class[0]);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException ex) {
                Method method = declaringClass.getDeclaredMethod("is" + methodName, new Class[0]);
                method.setAccessible(true);
                return method;
            }
        }

        public String toString() {
            if (this.toStringCache == null || this.toStringCache.isEmpty()) {
                this.toStringCache = new ToStringBuilder((Object)this).append("owner", (Object)this.owner.getName()).append("name", (Object)this.name).toString();
                this.toStringCache = this.toStringCache.intern();
            }
            return this.toStringCache;
        }

        public String getLabel() {
            return ReflectUtils.getShortClassName(this.owner) + "." + this.getName();
        }

        public String getUserVisibleLabel() {
            if (this.prettyName == null) {
                String propName = this.getName();
                StringBuffer text = new StringBuffer();
                for (int i = propName.length() - 1; i > -1; --i) {
                    char current = propName.charAt(i);
                    if (i == 0) {
                        text.append(Character.toUpperCase(current));
                        continue;
                    }
                    if (Character.isUpperCase(current) && !Character.isUpperCase(propName.charAt(i - 1))) {
                        text.append(current);
                        text.append(' ');
                        continue;
                    }
                    if (Character.isUpperCase(current) && i != propName.length() - 1 && !Character.isUpperCase(propName.charAt(i + 1))) {
                        text.append(current);
                        text.append(' ');
                        continue;
                    }
                    text.append(current);
                }
                text.reverse();
                this.prettyName = text.toString();
            }
            return this.prettyName;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Property)) {
                return false;
            }
            Property otherProp = (Property)other;
            return this.name.equals(otherProp.name) && (this.owner.isAssignableFrom(otherProp.owner) || otherProp.owner.isAssignableFrom(this.owner));
        }

        public int hashCode() {
            int hash = 356;
            int nameHash = null == this.name ? 0 : this.name.hashCode();
            hash = 31 * hash + nameHash;
            return hash;
        }

        @Override
        public Property<T> getProperty() {
            return this;
        }

        @Override
        public T resolveValue(Object baseObj) {
            return (T)PropsHelper.getPropertyValue((PropertiedObject)baseObj, this);
        }

        @Override
        public Object resolveObj(Object baseObj, int idx) {
            if (idx == 0) {
                return this.resolveValue(baseObj);
            }
            return baseObj;
        }

        @Override
        public Property getBaseProperty() {
            return this;
        }

        @Override
        public Property[] getPropertyChain() {
            Property[] newProps = new Property[]{this};
            return newProps;
        }
    }

    public static abstract class Props
    implements Iterable<Property> {
        private final Map<String, Property> properties;
        private static final Map<String, String> propToFieldNames = new WeakHashMap<String, String>();
        private static final Pattern UNDERSCORE = Pattern.compile("_", 16);

        protected Props() {
            LinkedHashMap propMap = new LinkedHashMap();
            HashMap<String, Field> classFields = new HashMap<String, Field>();
            Class declaringClass = this.getClass().getDeclaringClass();
            if (declaringClass == null) {
                declaringClass = LangUtils.getDeclaringClass(this.getClass());
            }
            this.getFields(classFields, declaringClass);
            Field[] toFill = this.getClass().getFields();
            for (int i = 0; i < toFill.length; ++i) {
                Field setup = toFill[i];
                try {
                    if (!setup.getType().isAssignableFrom(Property.class) || setup.get(this) != null) continue;
                    String name = Props.propToFieldName(setup.getName());
                    if (classFields.containsKey(name)) {
                        Field classField = (Field)classFields.get(name);
                        Property newProp = new Property((Class<? extends PropertiedObject>)declaringClass, classField.getName());
                        setup.set(this, newProp);
                        propMap.put(name, newProp);
                        continue;
                    }
                    throw new RuntimeException("Cannot automatically setup Property " + setup + ": there is no corresponding business object field.");
                }
                catch (IllegalAccessException e) {
                    OrderMate.LOG.warn("Error setting up Property " + setup, (Throwable)e);
                }
            }
            this.properties = Collections.unmodifiableMap(propMap);
        }

        public Property[] asArray() {
            return this.properties.values().toArray(new Property[this.properties.size()]);
        }

        private void getFields(Map<String, Field> fields, Class toCheck) {
            if (toCheck != null) {
                this.getFields(fields, toCheck.getSuperclass());
                Field[] currentFields = toCheck.getDeclaredFields();
                for (int i = 0; i < currentFields.length; ++i) {
                    Field field = currentFields[i];
                    String name = field.getName().toUpperCase();
                    fields.put(name, field);
                }
            }
        }

        private static String propToFieldName(String propName) {
            String fieldName = propToFieldNames.get(propName);
            if (fieldName == null) {
                fieldName = UNDERSCORE.matcher(propName).replaceAll("").toUpperCase();
                propToFieldNames.put(propName, fieldName);
            }
            return fieldName;
        }

        @Override
        public Iterator<Property> iterator() {
            return this.properties.values().iterator();
        }

        public Set<Property> getPropertySet() {
            return new HashSet<Property>(this.properties.values());
        }

        public boolean hasProperty(String propertyName) {
            return this.properties.containsKey(Props.propToFieldName(propertyName));
        }

        public Property getProperty(String propertyName) {
            return this.properties.get(Props.propToFieldName(propertyName));
        }
    }
}

