/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceLocator {
    public static final Log LOG = LogFactory.getLog(ServiceLocator.class);
    private static final ServiceLocator instance = new ServiceLocator();
    private final ThreadLocal<Map<Class, Object>> serviceCache = new ThreadLocal();
    private int serverPort = 11100;
    private static Context theContext = null;

    public static <T> T locate(Class<T> ejbInterface) {
        T service = instance.checkCache(ejbInterface);
        LOG.info((Object)"ServiceLocator method is getting called. ");
        if (service != null) {
            if (LOG.isDebugEnabled()) {
                Exception ex = new Exception();
                LOG.debug((Object)("\nCalled from " + ex.getStackTrace()[0] + "\n    at " + ex.getStackTrace()[1] + "\n    at " + ex.getStackTrace()[2] + "\n    at " + ex.getStackTrace()[3] + "\n    at " + ex.getStackTrace()[3]));
            }
            LOG.debug((Object)("Using cached instance from ServiceLocator for " + ejbInterface.getSimpleName()));
            return service;
        }
        if (SimpleRMI.isInitialized()) {
            return instance.lookupViaRMI(ejbInterface);
        }
        service = instance.lookup(ejbInterface);
        instance.cache(ejbInterface, service);
        return service;
    }

    public static <T> T create(Class<T> statefulEjbInterface) {
        return instance.lookup(statefulEjbInterface);
    }

    private <T> void cache(Class<T> key, T service) {
        if (service != null) {
            this.serviceCache.get().put(key, service);
        } else {
            this.serviceCache.get().remove(key);
        }
    }

    private <T> T lookup(Class<T> ejbInterface) {
        try {
            Object retVal;
            LOG.debug((Object)("Using JNDI to lookup : " + ejbInterface.getName() + " from " + Thread.currentThread().getName()));
            if (theContext == null) {
                ServiceLocator.setContext(new InitialContext());
            }
            if ((retVal = theContext.lookup(ejbInterface.getName())) == null) {
                LOG.info((Object)("Could not find : " + ejbInterface.getName()));
            }
            return (T)retVal;
        }
        catch (NamingException ex) {
            LOG.debug((Object)("Service locator could not load : " + ejbInterface.getSimpleName()), (Throwable)ex);
            return null;
        }
    }

    private <T> T checkCache(Class<T> ejbInterface) {
        Map<Class, Object> threadsafeCacheMap = this.serviceCache.get();
        if (threadsafeCacheMap == null) {
            threadsafeCacheMap = new HashMap<Class, Object>();
            this.serviceCache.set(threadsafeCacheMap);
            return null;
        }
        return (T)threadsafeCacheMap.get(ejbInterface);
    }

    private <T> T lookupViaRMI(Class<T> interfaceToLookup) {
        try {
            OrderMate.LOG.debug("Looking up via RMI " + interfaceToLookup + " on port " + this.serverPort);
            return (T)SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), interfaceToLookup.getName(), this.serverPort);
        }
        catch (RemoteException ex) {
            LOG.error((Object)("Service locator could not load via RMI : " + interfaceToLookup.getName()), (Throwable)ex);
            return null;
        }
        catch (NotBoundException ex) {
            LOG.error((Object)("Service locator could not load via RMI : " + interfaceToLookup.getName()), (Throwable)ex);
            return null;
        }
    }

    public void setServerRMIPort(int port) {
        this.serverPort = port;
    }

    static <T> void setCachedInstance(Class<T> key, T service) {
        if (service != null) {
            ServiceLocator.instance.serviceCache.get().put(key, service);
        } else {
            ServiceLocator.instance.serviceCache.get().remove(key);
        }
    }

    public static synchronized void setContext(Context context) {
        theContext = context;
    }
}

