/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.persistence.ComponentFactory;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceDelegateRemote;
import au.com.ordermate.persistence.PersistenceException;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import java.util.List;
import javax.ejb.EJBException;
import ordermate.OrderMate;

final class UnsafePersistenceDelegateWrapper
implements PersistenceDelegateRemote {
    private final PersistenceDelegateRemote persistenceDelegate;

    protected UnsafePersistenceDelegateWrapper(PersistenceDelegateRemote delegate) {
        this.persistenceDelegate = delegate;
    }

    @Override
    public <T extends PersistentObjectI> List<T> getObjectList(Class<T> type, String query, Object[] params, SessionI session) {
        try {
            return this.persistenceDelegate.getObjectList(type, query, params, session);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Exception in getObjectList executing query : " + query);
            this.processException(e);
            return null;
        }
    }

    @Override
    public <T extends PersistentObjectI> T getObject(Class<T> type, String query, Object[] params, SessionI session) {
        try {
            return this.persistenceDelegate.getObject(type, query, params, session);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Exception in getObject executing query : " + query);
            this.processException(e);
            return null;
        }
    }

    @Override
    public boolean isHeadOffice() {
        return this.persistenceDelegate.isHeadOffice();
    }

    @Override
    public Long save(PersistentObject toSave) {
        try {
            return this.persistenceDelegate.save(toSave);
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public void delete(long ID, Class<? extends PersistentObjectI> objectType) {
        try {
            this.persistenceDelegate.delete(ID, objectType);
        }
        catch (Exception e) {
            this.processException(e);
        }
    }

    @Override
    public <T extends PersistentObject> boolean hasChanged(T toCheck) {
        try {
            return this.persistenceDelegate.hasChanged(toCheck);
        }
        catch (Exception e) {
            this.processException(e);
            return false;
        }
    }

    @Override
    public PersistentObject createFromSnapShot(PersistentObjectSnapshot snapShot) {
        try {
            return this.persistenceDelegate.createFromSnapShot(snapShot);
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public <T extends PersistentObject> void update(T toUpdate, PropertiedObject.Property<?>[] properties) {
        try {
            this.persistenceDelegate.update(toUpdate, properties);
        }
        catch (Exception e) {
            this.processException(e);
        }
    }

    @Override
    public <T extends PersistentObject> T preload(T toPreload) {
        try {
            return this.persistenceDelegate.preload(toPreload);
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public <T extends PersistentObject> T preload(PersistentObjDescriptor<T> toPreload, List<PropertiedObject.Property<?>[]> propsToExpand) {
        try {
            return this.persistenceDelegate.preload(toPreload, propsToExpand);
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public <T extends PersistentObject> T getByID(long ID, Class<T> type, SessionI session) {
        return this.persistenceDelegate.getByID(ID, type, session);
    }

    @Override
    public <T extends PersistentObject> T getByID(long ID, Class<T> type) {
        try {
            return this.persistenceDelegate.getByID(ID, type);
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public <T extends PersistentObjectI> List<T> refreshList(List<T> persistentObjects, Class<T> objType) {
        try {
            return this.persistenceDelegate.refreshList(persistentObjects, objType);
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public Object[][] executeQuery(String sql, Object[] params) {
        try {
            return this.persistenceDelegate.executeQuery(sql, params);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Exception in executeQuery executing query : " + sql);
            this.processException(e);
            return null;
        }
    }

    @Override
    public long executeInsert(String sql, Object[] params) {
        try {
            return this.persistenceDelegate.executeInsert(sql, params);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Exception in executeInsert executing query : " + sql);
            this.processException(e);
            return -1L;
        }
    }

    @Override
    public void executeUpdate(String sql, Object[] params) {
        try {
            this.persistenceDelegate.executeUpdate(sql, params);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Exception in executeUpdate executing query : " + sql);
            this.processException(e);
        }
    }

    @Override
    public ComponentFactory createComponentFactory() {
        try {
            return this.persistenceDelegate.createComponentFactory();
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public PersistenceMetaData createMetaData() {
        try {
            return this.persistenceDelegate.createMetaData();
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public <T> T runSync(Executable<T> exec) {
        try {
            return this.persistenceDelegate.runSync(exec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processException(Exception ex) {
        if (ex instanceof EJBException) {
            OrderMate.LOG.warn("Unwrapping EJB exception : ", (Throwable)ex);
            throw new PersistenceException(ex.getCause());
        }
        throw new PersistenceException(ex);
    }
}

