/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.Persistence;
import au.com.ordermate.persistence.PersistenceException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceWrapper;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.UnsafePersistence;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UnsafePersistenceWrapper
implements Persistence,
PersistenceWrapper {
    public static final LogStrategy THROW_RUNTIME_EXCEPTIONS = new LogStrategy();
    public static final LogStrategy LOG_EXCEPTIONS = new LogStrategy();
    public static final LogStrategy LOG_AND_THROW = new LogStrategy();
    private LogStrategy errorStrategy;
    private UnsafePersistence persistence;

    public UnsafePersistenceWrapper(UnsafePersistence toWrap, LogStrategy newErrorStrategy) {
        this.persistence = toWrap;
        this.errorStrategy = newErrorStrategy;
    }

    @Override
    public UnsafePersistence getWrappedPersistence() {
        return this.persistence;
    }

    public void setWrappedPersistence(UnsafePersistence toWrap) {
        this.persistence = toWrap;
    }

    private void handleException(Exception e) {
        if (this.errorStrategy == THROW_RUNTIME_EXCEPTIONS) {
            throw new RuntimeException("Throwing error in persistence", e);
        }
        if (this.errorStrategy != LOG_EXCEPTIONS) {
            if (e instanceof PersistenceException) {
                throw (PersistenceException)e;
            }
            OrderMateLog.LOG.error("Logging error in persistence, runtime exception will be thrown", (Throwable)e);
            throw new RuntimeException("Error in persistence", e);
        }
        OrderMateLog.LOG.error("Logging error in persistence", (Throwable)e);
    }

    public PersistentList createList(PropertiedObject.Property property) {
        try {
            PersistentList toReturn = this.persistence.createList(property);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public Reference createReference(PropertiedObject.Property property) {
        try {
            Reference toReturn = this.persistence.createReference(property);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public <T extends PersistentObject> T preload(Class<T> type, Long ID) {
        try {
            PersistentObject toReturn = this.persistence.preload(type, ID);
            return (T)toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public long saveOrUpdate(PersistentObjectSnapshot toSave) {
        try {
            long toReturn = this.persistence.saveOrUpdate(toSave);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    @Override
    public void update(PersistentObjectSnapshot toUpdate, PropertiedObject.Property[] properties) {
        try {
            this.persistence.update(toUpdate, properties);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void delete(PersistentObjDescriptor toDelete) {
        try {
            this.persistence.delete(toDelete);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean hasChanged(PersistentObjectSnapshot toCheck) {
        try {
            return this.persistence.hasChanged(toCheck);
        }
        catch (Exception e) {
            this.handleException(e);
            return true;
        }
    }

    public List getObjectList(Class type, String query, Object[] params, SessionI session) {
        try {
            List toReturn = this.persistence.getObjectList(type, query, params, session);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Object[][] executeQuery(String sql, Object[] params) {
        try {
            Object[][] toReturn = this.persistence.executeQuery(sql, params);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public long executeInsert(String sql, Object[] params) {
        try {
            return this.persistence.executeInsert(sql, params);
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    @Override
    public void executeUpdate(String sql, Object[] params) {
        try {
            this.persistence.executeUpdate(sql, params);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String getClassTable(Class type) {
        try {
            String toReturn = this.persistence.getClassTable(type);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public String getPropertyColumn(PropertiedObject.Property property) {
        try {
            String toReturn = this.persistence.getPropertyColumn(property);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public String getPropertyTable(PropertiedObject.Property property) {
        return this.getClassTable((Class)property.getOwner());
    }

    @Override
    public String getDiscriminatorColumn(Class type) {
        try {
            String toReturn = this.persistence.getDiscriminatorColumn(type);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public String getDiscriminatorValue(Class type) {
        try {
            String toReturn = this.persistence.getDiscriminatorValue(type);
            return toReturn;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public Object runSync(Executable exec) {
        try {
            return this.persistence.runSync(exec);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public PropertiedObject.Property getOwnerProperty(PropertiedObject.Property prop) {
        return PersistenceManager.getPersistenceMetaData().getOwnerProperty(prop);
    }

    @Override
    public <T extends PersistentObjectI> boolean classSupportsQueries(Class<T> clazz) {
        return PersistenceManager.getPersistenceMetaData().classSupportsQueries(clazz);
    }

    @Override
    public Map<String, ?> getPropertyMetadata(PropertiedObject.Property prop) {
        try {
            return this.persistence.getPropertyMetadata(prop);
        }
        catch (Exception e) {
            this.handleException(e);
            return Collections.EMPTY_MAP;
        }
    }

    @Override
    public boolean usesSnapshot() {
        return true;
    }

    public static class LogStrategy {
        private LogStrategy() {
        }
    }
}

