/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;

public class VersionedFKReference<T extends PersistentObject>
extends FKReference<T> {
    private transient String versionQuery;

    public VersionedFKReference(Class<T> refType) {
        super(refType);
    }

    @Override
    public T get() {
        if (this.isExpanded()) {
            PersistentObject current = (PersistentObject)super.get();
            if (this.checkVersion(current)) {
                return (T)current;
            }
            Object freshObj = PersistenceManager.reacquire(current);
            this.set(freshObj);
            return (T)freshObj;
        }
        return (T)((PersistentObject)super.get());
    }

    private boolean checkVersion(T toCheck) {
        int currentVersion;
        if (toCheck == null || !((PersistentObject)toCheck).isPersistent()) {
            return true;
        }
        int toCheckVersion = ((PersistentObject)toCheck).getVersion();
        return toCheckVersion == (currentVersion = this.getVersionFromDB((PersistentObject)toCheck));
    }

    private int getVersionFromDB(PersistentObject classToCheck) {
        if (classToCheck == null) {
            throw new IllegalArgumentException("Cannot compare null object " + this.getObjectType());
        }
        Object[][] version = PersistenceManager.getPersistenceDelegate().executeQuery(this.getVersionQuery(classToCheck), new Object[]{classToCheck.getID()});
        if (version == null || version.length == 0) {
            return -1;
        }
        return ((Number)version[0][0]).intValue();
    }

    protected String getVersionQuery(PersistentObject classToCheck) {
        if (this.versionQuery == null) {
            this.versionQuery = Query.selectFunc(classToCheck.getProperties().VERSION + " AS value").equalsParam(classToCheck.getProperties().ID).toString();
        }
        return this.versionQuery;
    }
}

