/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.cache;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.cache.CacheManagerI;
import au.com.ordermate.persistence.cache.NullCacheManager;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.cache.remote.InvalidateableRemoteCache;
import au.com.ordermate.persistence.cache.remote.RemoteCacheImpl;
import au.com.ordermate.persistence.cache.remote.RemoteCacheSubscriptionService;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.maps.ITypeMap;
import au.com.ordermate.util.maps.TypeHashMap;
import au.com.ordermate.util.maps.TypeSoftHashMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;

public class CacheManager
implements CacheManagerI {
    protected final Object cacheLock = new Object();
    protected final Cache referenceCache = new Cache();
    private InvalidateableRemoteCache remoteCache = null;
    protected final int RMI_HOST_PORT;
    private static CacheManagerI instance;
    private final Map<Class, Integer> classCount = Config.isDebuging() ? new HashMap() : null;

    protected CacheManager(int port) {
        this.RMI_HOST_PORT = port;
    }

    public static CacheManagerI getInstance() {
        if (instance == null) {
            return NullCacheManager.NULL_OBJECT;
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static void initialize(int port) {
        if (instance != null) {
            throw new IllegalStateException("Cache manager has already been initialized.");
        }
        instance = new CacheManager(port);
    }

    @Override
    public synchronized InvalidateableRemoteCache getRemoteCache(String name, InetAddress address, int rmiPort) {
        try {
            if (this.remoteCache == null) {
                this.remoteCache = new RemoteCacheImpl(name, address, rmiPort);
            }
        }
        catch (Exception ex) {
            OrderMateLog.LOG.error("Could not construct remote cache.");
        }
        return this.remoteCache;
    }

    public static void setCacheManager(CacheManagerI manager) {
        instance = manager;
    }

    public static final RemoteCacheSubscriptionService getRemoteCacheSubscribeService() throws UnknownHostException, NotBoundException, RemoteException {
        RemoteCacheSubscriptionService subscribeService;
        String nextAddress = Terminal.getServerMateTerminal().getIPAddress();
        try {
            subscribeService = (RemoteCacheSubscriptionService)SimpleRMI.getObject(InetAddress.getByName(nextAddress), "RemoteCacheSubscriptionService", instance.getRmiHostPort());
        }
        catch (UnknownHostException ex) {
            OrderMate.LOG.error("Could not resolve remote host : " + nextAddress, (Throwable)ex);
            throw ex;
        }
        catch (NotBoundException ex) {
            OrderMate.LOG.error("Cache Subscription service could not be found :RemoteCacheSubscriptionService", (Throwable)ex);
            throw ex;
        }
        catch (RemoteException ex) {
            throw ex;
        }
        return subscribeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheObject(PersistentObject object) {
        if (object.isPersistent()) {
            Object object2 = this.cacheLock;
            synchronized (object2) {
                this.referenceCache.cacheObject(object.getSnapshot());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheObject(PersistentObjectSnapshot snapshot) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.referenceCache.cacheObject(snapshot);
        }
    }

    @Override
    public void cacheObjects(Collection<? extends PersistentObject> objects) {
        if (objects == null || objects.size() == 0) {
            return;
        }
        Iterator<? extends PersistentObject> it = objects.iterator();
        while (it.hasNext()) {
            this.cacheObject(it.next());
        }
    }

    @Override
    public void cacheSnapshots(Collection snapshots) {
        Iterator it = snapshots.iterator();
        while (it.hasNext()) {
            this.cacheObject((PersistentObjectSnapshot)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentObject retrieveObject(Long id, Class type) {
        PersistentObjectSnapshot snapshot;
        Map<Class, Integer> map = this.cacheLock;
        synchronized (map) {
            snapshot = (PersistentObjectSnapshot)this.referenceCache.getObject(new PersistentObjDescriptor(id, type));
        }
        if (snapshot != null) {
            if (this.classCount != null) {
                map = this.classCount;
                synchronized (map) {
                    if (!this.classCount.containsKey(type)) {
                        this.classCount.put(type, 1);
                    } else {
                        this.classCount.put(type, 1 + this.classCount.get(type));
                    }
                }
            }
            return PersistenceManager.createFromSnapShot(snapshot);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(PersistentObjDescriptor descriptor) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.referenceCache.invalidateObject(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(Class type) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.referenceCache.clearTypeCache(type);
            OrderMate.LOG.info(type + " reference cache has been cleared");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEntireCache() {
        PersistenceManager.getInstance().clearLocalCaches();
        Object object = this.cacheLock;
        synchronized (object) {
            this.referenceCache.clearCache();
            OrderMate.LOG.info("Entire cache has been cleared...");
        }
    }

    @Override
    public void subscribeToRemoteCache(InetAddress localhost, InetAddress server) throws RemoteException, NotBoundException {
        RemoteCacheSubscriptionService service = (RemoteCacheSubscriptionService)SimpleRMI.getObject(server, "RemoteCacheSubscriptionService", instance.getRmiHostPort());
        if (!SimpleRMI.isSharingObject(InvalidateableRemoteCache.RMI_OBJ_NAME)) {
            SimpleRMI.shareObject(CacheManager.getInstance().getRemoteCache(InvalidateableRemoteCache.RMI_OBJ_NAME, localhost, SimpleRMI.getSharePort()), InvalidateableRemoteCache.RMI_OBJ_NAME);
        }
        service.subscribe(InvalidateableRemoteCache.RMI_OBJ_NAME, localhost, SimpleRMI.getSharePort());
    }

    protected ITypeMap getCacheMap() {
        return new TypeSoftHashMap();
    }

    @Override
    public void cacheFreshObject(PersistentObject obj) {
        this.cacheObject(obj.getLastSavedSnapshot());
    }

    @Override
    public int getRmiHostPort() {
        return this.RMI_HOST_PORT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalClassesAccessed() {
        long tally = 0L;
        if (this.classCount != null) {
            Map<Class, Integer> map = this.classCount;
            synchronized (map) {
                for (Integer nextCount : this.classCount.values()) {
                    tally += (long)nextCount.intValue();
                }
            }
        }
        return tally;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getNumberOfClassesAccessed(Class type) {
        if (this.classCount != null) {
            Map<Class, Integer> map = this.classCount;
            synchronized (map) {
                return this.classCount.get(type);
            }
        }
        return 0;
    }

    protected class Cache {
        private final ITypeMap cache;

        public Cache() {
            boolean bError = false;
            ITypeMap map = null;
            try {
                map = CacheManager.this.getCacheMap();
            }
            catch (Throwable error) {
                bError = true;
            }
            this.cache = !bError && map != null ? map : new TypeHashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache() {
            Object object = CacheManager.this.cacheLock;
            synchronized (object) {
                this.cache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearTypeCache(Class type) {
            Object object = CacheManager.this.cacheLock;
            synchronized (object) {
                this.cache.clearTypeMap(type);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PersistentObjectI getObject(PersistentObjDescriptor descriptor) {
            Object object = CacheManager.this.cacheLock;
            synchronized (object) {
                return (PersistentObjectI)this.cache.get(descriptor.getObjectType(), descriptor.getID());
            }
        }

        public void cacheObject(PersistentObjectI object) {
            if (object != null && object.getID() != null) {
                this.cache.put(object.getObjectType(), object.getID(), object);
            }
        }

        private void invalidateObject(PersistentObjDescriptor descriptor) {
            if (descriptor != null && descriptor.getID() != null) {
                this.cache.remove(descriptor.getObjectType(), descriptor.getID());
            }
        }
    }
}

