/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.cache;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SimplePersistentObject;
import au.com.ordermate.persistence.cache.CacheManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CachedFKList<E extends PersistentObject>
extends FKList<E> {
    public CachedFKList(Class<E> clazz, PropertiedObject.Property prop) {
        super(clazz, prop);
    }

    @Override
    protected Collection<E> resolve() throws Exception {
        List<SimplePersistentObject> objectIDs = PersistenceManager.getObjectList(SimplePersistentObject.class, this.getIDSql(), new Object[]{this.getOwner().getID()});
        if (objectIDs == null) {
            return new ArrayList();
        }
        HashSet<Long> unresolvedIDSet = new HashSet<Long>();
        boolean someCached = false;
        Collection<PersistentObject> objectList = new ArrayList();
        Iterator<SimplePersistentObject> it = objectIDs.iterator();
        while (it.hasNext()) {
            Long ID = ((PersistentObjectI)it.next()).getID();
            PersistentObject obj = (PersistentObject)CacheManager.getInstance().retrieveObject(ID, this.getType());
            if (obj != null) {
                objectList.add(obj);
                someCached = true;
                continue;
            }
            unresolvedIDSet.add(ID);
        }
        if (someCached) {
            if (!unresolvedIDSet.isEmpty()) {
                objectList.addAll(this.resolve(unresolvedIDSet));
            }
        } else {
            objectList = super.resolve();
            this.cache(objectList);
        }
        return objectList;
    }

    private List<E> resolve(Set<Long> IDSet) {
        ObjectQuery query = this.getObjectQuery().copy().wherePropertyIn(new PropertiedObject.Property(this.getType(), "ID"), new ArrayList<Long>(IDSet));
        List objects = PersistenceManager.getObjectList(this.getType(), query.toString(), new Object[]{this.getOwner().getID()});
        this.cache(objects);
        return objects;
    }

    private void cache(Collection persistentObjects) {
        CacheManager.getInstance().cacheObjects(persistentObjects);
    }

    private String getIDSql() {
        ObjectQuery query = this.getObjectQuery().copy();
        query = query.clearSelect().selectID();
        String sql = query.toString();
        return sql;
    }
}

