/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.cache;

import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.cache.CacheManager;

public class CachedFKReference<T extends PersistentObject>
extends FKReference<T> {
    public CachedFKReference(Class<T> refType) {
        super(refType);
    }

    public static <E extends PersistentObject> CachedFKReference<E> create(Class<E> refType) {
        return new CachedFKReference<E>(refType);
    }

    @Override
    public T resolve() throws Exception {
        Long objID = this.getObjectID();
        if (objID == null) {
            return null;
        }
        PersistentObjectI resolvedObject = null;
        resolvedObject = (PersistentObjectI)this.resolveViaSession(objID, this.getType());
        if (resolvedObject == null && (resolvedObject = (PersistentObject)CacheManager.getInstance().retrieveObject(objID, this.getType())) != null) {
            PersistentObjectI original = resolvedObject;
            if ((resolvedObject = this.registerReference(resolvedObject)) != original) {
                CacheManager.getInstance().cacheObject(resolvedObject);
            }
        }
        if (resolvedObject == null && (resolvedObject = super.resolve()) != null) {
            CacheManager.getInstance().cacheObject(resolvedObject);
        }
        return (T)resolvedObject;
    }

    @Override
    public void set(T obj) {
        super.set(obj);
    }
}

