/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.cache;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.cache.LocalCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;

public class LocalCacheListManager<E extends PersistentObjectI>
implements LocalCache,
Serializable {
    private PersistentList<E> theList;
    private volatile Map<Long, E> listMappedByID;

    public LocalCacheListManager(PersistentList<E> list) {
        this.theList = list;
        PersistenceManager.getInstance().registerLocalCache(this);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        PersistenceManager.getInstance().registerLocalCache(this);
    }

    @Override
    public synchronized void clearCache() {
        this.listMappedByID = null;
        this.theList = this.theList.clone();
        this.theList.collapseUnsafe();
    }

    public synchronized List<E> getList() {
        return Collections.unmodifiableList(this.theList);
    }

    public synchronized PersistentList<E> getListUnsafe() {
        return this.theList;
    }

    public synchronized void setList(PersistentList<E> newList) {
        OrderMate.LOG.info("Setting new cache list:" + newList.getClass());
        this.theList = newList.clone();
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getByID(long id) {
        if (this.listMappedByID == null) {
            this.listMappedByID = PersistenceManager.getHashMapFromObjectList(this.getList());
        }
        LocalCacheListManager localCacheListManager = this;
        synchronized (localCacheListManager) {
            if (this.listMappedByID != null) {
                return (E)((PersistentObjectI)this.listMappedByID.get(id));
            }
        }
        return this.getByID(id);
    }
}

