/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.cache;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.cache.LocalCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import ordermate.OrderMate;

public class LocalCachedReference<T extends PersistentObjectI>
implements LocalCache,
Reference<T> {
    private Reference<T> decoratedReference;

    public LocalCachedReference(Reference<T> reference) {
        this.decoratedReference = reference;
        PersistenceManager.getInstance().registerLocalCache(this);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        PersistenceManager.getInstance().registerLocalCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        boolean isExpanded;
        LocalCachedReference localCachedReference = this;
        synchronized (localCachedReference) {
            isExpanded = this.decoratedReference.isExpanded();
            if (isExpanded) {
                return this.decoratedReference.get();
            }
        }
        while (!isExpanded) {
            this.decoratedReference.get();
            localCachedReference = this;
            synchronized (localCachedReference) {
                isExpanded = this.decoratedReference.isExpanded();
                if (isExpanded) {
                    T obj = this.decoratedReference.get();
                    this.decoratedReference.set(obj);
                    return obj;
                }
            }
        }
        throw new IllegalStateException("Really?  Is it possible to get here?");
    }

    @Override
    public synchronized void clearCache() {
        this.decoratedReference.collapse();
    }

    @Override
    public synchronized boolean belongsToOwner() {
        return this.decoratedReference.belongsToOwner();
    }

    @Override
    public synchronized Long getObjectID() {
        return this.decoratedReference.getObjectID();
    }

    @Override
    public synchronized boolean isExpanded() {
        return this.decoratedReference.isExpanded();
    }

    @Override
    public synchronized boolean isNull() {
        return this.decoratedReference.isNull();
    }

    @Override
    public synchronized void set(T value) {
        this.decoratedReference.set(value);
    }

    @Override
    public synchronized void setObjectID(Long newObjectID) {
        this.decoratedReference.setObjectID(newObjectID);
    }

    @Override
    public synchronized void setOwner(PersistentObject owner) {
        this.decoratedReference.setOwner(owner);
    }

    @Override
    public void deleteChild() {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public boolean hasChildChanged() {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void prepareForSave(SaveContext context) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Class<T> getType() {
        return this.decoratedReference.getType();
    }

    @Override
    public void saveChild() {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public synchronized Object clone() {
        return new LocalCachedReference<T>((Reference)this.decoratedReference.clone());
    }

    @Override
    public void collapse() {
        this.clearCache();
    }

    @Override
    public void initSQL() throws Exception {
        this.decoratedReference.initSQL();
    }

    @Override
    public Long getID() {
        return this.decoratedReference.getID();
    }

    public Class getObjectType() {
        return this.decoratedReference.getObjectType();
    }

    @Override
    public boolean isPersistent() {
        return this.decoratedReference.isPersistent();
    }

    public synchronized void setReferenceUnsafe(Reference<T> reference) {
        OrderMate.LOG.info("Setting new Reference:" + reference.getClass());
        this.decoratedReference = reference;
    }

    public Reference getReferenceUnsafe() {
        return this.decoratedReference;
    }
}

