/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.cache;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import java.io.Serializable;

public class PersistentObjDescriptor<T extends PersistentObject>
implements PersistentObjectI,
Serializable {
    private final Long id;
    private final Class<T> clazz;

    public PersistentObjDescriptor(PersistentObjectI object) {
        this(object.getID(), object.getObjectType());
    }

    public PersistentObjDescriptor(Long theId, Class<T> theClazz) {
        if (theId == null) {
            throw new IllegalArgumentException("Cannot create a descriptor from non-persisted object of class (ID is null): " + theClazz);
        }
        this.id = theId;
        this.clazz = theClazz;
    }

    @Override
    public Long getID() {
        return this.id;
    }

    public Class<T> getObjectType() {
        return this.clazz;
    }

    public boolean equals(Object other) {
        if (this.id == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        PersistentObjDescriptor theOther = (PersistentObjDescriptor)other;
        if (this.id != theOther.id) {
            return false;
        }
        return this.clazz.equals(theOther.clazz);
    }

    public int hashCode() {
        int hash = 347;
        hash = (int)((long)hash * (this.id != null ? this.id : 1L));
        return hash *= this.clazz.hashCode();
    }

    @Override
    public boolean isPersistent() {
        return this.getID() != null;
    }

    public String toString() {
        return this.clazz.getSimpleName() + " : " + this.getID();
    }

    public T resolveObject() {
        if (!this.isPersistent()) {
            return null;
        }
        return PersistenceManager.getByID(this.getID(), this.getObjectType());
    }

    public PersistentObjDescriptor createResolvedDescriptor(PersistentObject resolved) {
        if (resolved.getObjectType().equals(this.clazz) && resolved.getID().equals(this.getID())) {
            return this;
        }
        return new PersistentObjDescriptor<T>(resolved);
    }
}

