/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.cache.remote;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.cache.remote.InvalidateableRemoteCache;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RemoteCacheImpl
extends UnicastRemoteObject
implements InvalidateableRemoteCache {
    private String name = "";
    private InetAddress IPAddress;
    private int port;

    private RemoteCacheImpl() throws RemoteException {
        try {
            this.IPAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            OrderMateLog.LOG.warn("Could not get localhost when constructing remoteCache", (Throwable)uhe);
        }
    }

    public RemoteCacheImpl(String cacheName, InetAddress ipaddress, int rmiPort) throws RemoteException {
        this();
        this.name = cacheName;
        this.IPAddress = ipaddress;
        this.port = rmiPort;
    }

    @Override
    public void invalidateEntireCache() throws RemoteException {
        CacheManager.getInstance().clearEntireCache();
    }

    @Override
    public void invalidateObject(PersistentObjectI object) throws RemoteException {
        OrderMateLog.LOG.debug("Received invalidation for " + object);
        CacheManager.getInstance().invalidateObject(new PersistentObjDescriptor(object));
    }

    @Override
    public void invalidateObjects(Collection persistentObjectIs) throws RemoteException {
        OrderMateLog.LOG.debug("Received invalidation for collection : " + persistentObjectIs);
        Iterator it = persistentObjectIs.iterator();
        while (it.hasNext()) {
            CacheManager.getInstance().invalidateObject(new PersistentObjDescriptor((PersistentObjectI)it.next()));
        }
    }

    @Override
    public void invalidateType(Class type) throws RemoteException {
        CacheManager.getInstance().clearCache(type);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RemoteCacheImpl)) {
            return false;
        }
        RemoteCacheImpl otherCache = (RemoteCacheImpl)other;
        boolean isEquals = true;
        if (this.IPAddress != null && otherCache.IPAddress != null) {
            isEquals &= this.IPAddress.equals(otherCache.IPAddress);
        } else {
            return super.equals(other);
        }
        isEquals &= this.name.equals(otherCache.name);
        return isEquals &= this.port == otherCache.port;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.name);
        builder.append((Object)this.IPAddress);
        builder.append(this.port);
        return builder.toHashCode();
    }
}

