/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.cache.remote;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.cache.remote.RemoteCacheSubscriptionService;
import au.com.ordermate.persistence.cache.remote.Subscribeable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class RemoteCacheSubscriptionServiceImpl
extends UnicastRemoteObject
implements RemoteCacheSubscriptionService {
    private Subscribeable publisher;

    protected RemoteCacheSubscriptionServiceImpl(Subscribeable thePublisher) throws RemoteException {
        this.publisher = thePublisher;
    }

    @Override
    public boolean subscribe(String cacheName, InetAddress address, int rmiPort) throws RemoteException {
        OrderMateLog.LOG.info("RemoteCacheSubscriptionServiceImpl: Subscribing remote cache " + cacheName + " from " + address + " on port:" + rmiPort);
        return this.publisher.subscribe(cacheName, address, rmiPort);
    }

    @Override
    public void unsubscribe(String cacheName, InetAddress address, int rmiPort) throws RemoteException {
        OrderMateLog.LOG.info("RemoteCacheSubscriptionServiceImpl: Unsubscribing remote cache " + cacheName + " from " + address + " on port:" + rmiPort);
        this.publisher.unsubscribe(cacheName, address, rmiPort);
    }
}

