/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.csvwritestrategy.csvcolumn;

import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.CSVColumn;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.StringUtils;
import java.text.Format;

public class PropertyAccessorCSVColumn
implements CSVColumn {
    private final PropertyAccessor propAccessor;
    private final String header;
    private final Format format;

    public PropertyAccessorCSVColumn(PropertyAccessor propAcc) {
        this(StringUtils.camelCaseToDisplayable(StringUtils.firstCharToUpperCase(propAcc.getProperty().getName())), propAcc, null);
    }

    public PropertyAccessorCSVColumn(String header, PropertyAccessor propAcc) {
        this(header, propAcc, null);
    }

    public PropertyAccessorCSVColumn(String header, PropertyAccessor propAcc, Format formatter) {
        this.header = header;
        this.propAccessor = propAcc;
        this.format = formatter;
    }

    @Override
    public String getColumnHeader() {
        return this.header;
    }

    @Override
    public String getColumnDataForObject(Object containsData) {
        Object propData = this.propAccessor.resolveValue(containsData);
        String result = null;
        result = propData != null ? (this.format == null ? propData.toString() : this.format.format(propData)) : "";
        return result;
    }
}

