/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SuperSaveable;
import au.com.ordermate.persistence.database.AbstractClassMap;
import au.com.ordermate.persistence.database.ColumnClassMap;
import au.com.ordermate.persistence.database.LPAPersistenceDelegate;
import au.com.ordermate.persistence.database.MappingUtils;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ModCountMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PropertyMapping;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.LangUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;

public abstract class AbstractColumnClassMap
extends AbstractClassMap
implements ColumnClassMap {
    public AbstractColumnClassMap(Class clazz) {
        super(clazz);
    }

    @Override
    public final String getColumn(PropertiedObject.Property property) {
        return MappingUtils.getColForProperty(property, this.getMappings());
    }

    @Override
    public ListMapping[] getListMappings() {
        return new ListMapping[0];
    }

    public ColumnPropertyMapping[] getMappings() {
        ColumnPropertyMapping[] mapings = this.addModCountMapping(this.getRawMappings());
        if (!this.mappingsSetup) {
            for (int i = 0; i < mapings.length; ++i) {
                ColumnPropertyMapping currentMap = mapings[i];
                if (currentMap.getTable() == null) continue;
                Assert.isTrue(!currentMap.getTable().equalsIgnoreCase(""), "Columns need to have a table associated with them or null set as a tablename.  Column name:" + currentMap.getCol() + " Current Map: " + currentMap.toString());
            }
            this.mappingsSetup = true;
        }
        return mapings;
    }

    protected ColumnPropertyMapping[] addModCountMapping(ColumnPropertyMapping[] mappings) {
        if (SuperSaveable.class.isAssignableFrom(this.getTypeClass())) {
            ColumnPropertyMapping[] modCountWrappedArray = new ColumnPropertyMapping[]{new ModCountMapping()};
            ColumnPropertyMapping[] combined = LangUtils.joinArrays(mappings, modCountWrappedArray, ColumnPropertyMapping.class);
            return combined;
        }
        return mappings;
    }

    public abstract ColumnPropertyMapping[] getRawMappings();

    @Override
    public PersistentList createList(PropertiedObject.Property property) throws Exception {
        return MappingUtils.createList(property, this.getListMappings());
    }

    @Override
    public Reference createReference(PropertiedObject.Property property) throws Exception {
        return MappingUtils.createReference(property, this.getMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistentObjectI> getObjectList(String query, Object[] params, DBConnectionInterface conn) throws Exception {
        ResultSet rs = conn.executeQuery(query, params);
        try {
            ArrayList<PersistentObjectI> objects = new ArrayList<PersistentObjectI>();
            int objectCount = 0;
            while (rs.next()) {
                PersistentObjectI created = this.createFromResultSet(rs);
                objects.add(created);
                if (++objectCount % 1000 != 0) continue;
                Thread.yield();
            }
            ArrayList<PersistentObjectI> arrayList = objects;
            return arrayList;
        }
        finally {
            conn.release(rs);
        }
    }

    protected PersistentObjectI createFromResultSet(ResultSet rs) throws Exception {
        PersistentObjectI retval = this.createRawObject();
        this.applyMappedProperties(retval, rs);
        if (retval instanceof PersistentObject && ((LPAPersistenceDelegate)PersistenceManager.getPersistenceDelegate()).isCallInitOnLoad()) {
            ((PersistentObject)retval).init();
        }
        return retval;
    }

    protected void applyMappedProperties(PersistentObjectI obj, ResultSet rs) throws Exception {
        ColumnPropertyMapping[] mappings = this.getMappings();
        AbstractColumnClassMap.applyMappedProperties(this, mappings, this.getListMappings(), obj, rs);
    }

    protected static void applyMappedProperties(ColumnClassMap classMap, ColumnPropertyMapping[] mappings, ListMapping[] listMappings, PersistentObjectI obj, ResultSet rs) throws Exception {
        Object map;
        int i;
        for (i = 0; i < mappings.length; ++i) {
            map = mappings[i];
            Object val = null;
            try {
                val = map.getFromResultSet(rs);
                map.setObjectFieldFromDBValue(obj, val);
                continue;
            }
            catch (Exception e) {
                String colNames = "";
                try {
                    ResultSetMetaData metaData = rs.getMetaData();
                    for (int colNameIndex = 1; colNameIndex <= metaData.getColumnCount(); ++colNameIndex) {
                        colNames = colNames + rs.getMetaData().getColumnName(colNameIndex) + ", ";
                    }
                }
                catch (Exception e2) {
                    colNames = "Exception : could not resolve column names";
                    OrderMate.LOG.warn("Exception generating column names in result set", (Throwable)e2);
                }
                throw new Exception("Couldn't apply mapped property\nClass: " + classMap.getTypeClass() + "\nClassMap: " + classMap + "\nDB Column: " + map.getCol() + "\nDB Table: " + map.getTable() + "\nProperty: " + map.getProperty() + "\nValue: " + val + "\nValue class: " + (val != null ? val.getClass().getName() : "null") + "\nApplied to " + obj.getClass() + " instance ID: " + obj.getID() + "\nUsing mapping: " + map.getClass().getSimpleName() + "\nResults set has " + colNames, e);
            }
        }
        for (i = 0; i < listMappings.length; ++i) {
            map = listMappings[i];
            try {
                ((ListMapping)map).setValue(obj);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Couldn't apply list property\nClass: " + classMap.getTypeClass() + "\nClassMap: " + classMap + "\nProperty: " + ((ListMapping)map).getProperty(), e);
            }
        }
    }

    @Override
    public PropertyMapping[] getPropertyMappings() {
        return this.getMappings();
    }

    @Override
    public Map<String, ?> getMetadata(PropertiedObject.Property property) {
        return MappingUtils.getMetadataForProperty(property, this.getMappings());
    }
}

