/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.OptimisticLockException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.database.AbstractColumnClassMap;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.QueryableColumnClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.DiscriminatorColumnMapping;
import au.com.ordermate.persistence.database.columnpropertymap.IDMapping;
import au.com.ordermate.persistence.database.columnpropertymap.VersionMapping;
import au.com.ordermate.persistence.database.idgeneration.IDGenerationStrategy;
import au.com.ordermate.sql.SQL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import ordermate.database.DBConnectionInterface;

public abstract class AbstractQueryableColumnClassMap
extends AbstractColumnClassMap
implements QueryableColumnClassMap {
    private String insertSQL;
    private String updateSQL;
    private String deleteSQL;
    private String changedSQL;
    private String unlockSQL;
    private String lockSQL;
    private String[] insertCols;
    private IDGenerationStrategy idStrategy;
    private PropertiedObject.Property[] writableProperties;
    private final String objectTable;
    private ColumnPropertyMapping[] mappings;

    public AbstractQueryableColumnClassMap(String table, Class<? extends PersistentObjectI> clazz) {
        super(clazz);
        this.objectTable = table;
        this.idStrategy = this.createIdGenerationStrategy();
    }

    protected IDGenerationStrategy createIdGenerationStrategy() {
        return null;
    }

    @Override
    public IDGenerationStrategy getIdGenerationStrategy() {
        return this.idStrategy;
    }

    @Override
    public ClassMap getLockableClassMap() {
        return this;
    }

    @Override
    public final String getTable() {
        return this.objectTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertObject(PersistentObjectSnapshot toInsert, DBConnectionInterface conn) throws Exception {
        if (this.insertSQL == null) {
            AbstractQueryableColumnClassMap abstractQueryableColumnClassMap = this;
            synchronized (abstractQueryableColumnClassMap) {
                this.insertCols = this.getColsForProps(this.getWritableProperties());
                if (this.idStrategy != null) {
                    String[] newCols = new String[this.insertCols.length + 1];
                    System.arraycopy(this.insertCols, 0, newCols, 1, this.insertCols.length);
                    newCols[0] = "ID";
                    this.insertCols = newCols;
                }
                this.insertSQL = SQL.insert(this.getTable(), this.insertCols);
            }
        }
        Object[] params = new Object[this.insertCols.length];
        this.fillOutParamsArray(toInsert, params, this.insertCols, this.idStrategy == null ? 0 : 1);
        long id = 0L;
        if (this.idStrategy != null) {
            params[0] = toInsert.get(PersistentObject.Properties.ID);
            if (params[0] == null) {
                ClassMap classMap = this.getLockableClassMap();
                synchronized (classMap) {
                    Long newId = this.idStrategy.generateNextId(conn);
                    id = newId;
                    params[0] = newId;
                    conn.executeInsert(this.insertSQL, params);
                }
            } else {
                id = (Long)params[0];
                conn.executeInsert(this.insertSQL, params);
            }
        } else {
            id = conn.executeInsert(this.insertSQL, params);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(PersistentObjectSnapshot<?> toUpdate, PropertiedObject.Property[] showPropertiesParam, DBConnectionInterface conn) throws Exception {
        try {
            String executeSQL;
            PropertiedObject.Property[] showProperties = showPropertiesParam;
            if (this.isVersioned() && SQL.supportsLock()) {
                this.lockTable(conn);
                this.checkVersion(toUpdate, conn);
            }
            if (this.updateSQL == null && showProperties == null) {
                AbstractQueryableColumnClassMap abstractQueryableColumnClassMap = this;
                synchronized (abstractQueryableColumnClassMap) {
                    this.updateSQL = this.getUpdateSQL(this.getColsForProps(this.getWritableProperties()));
                }
            }
            if (showProperties != null) {
                executeSQL = this.getUpdateSQL(this.getColsForProps(showProperties));
            } else {
                executeSQL = this.updateSQL;
                showProperties = this.getWritableProperties();
            }
            Object[] params = new Object[showProperties.length + 1];
            this.fillOutParamsArray(toUpdate, params, this.getColsForProps(showProperties), 0);
            params[params.length - 1] = toUpdate.get(PersistentObject.Properties.ID);
            conn.execute(executeSQL, params);
        }
        finally {
            if (this.isVersioned() && SQL.supportsLock()) {
                this.unlockTable(conn);
            }
        }
    }

    protected final String getUpdateSQL(String[] showCols) {
        return SQL.update(this.getTable(), showCols, this.isVersioned());
    }

    protected String[] getColsForProps(PropertiedObject.Property[] props) {
        return AbstractQueryableColumnClassMap.getColsForProps(this, props);
    }

    protected static String[] getColsForProps(QueryableColumnClassMap classMap, PropertiedObject.Property[] props) {
        HashSet<PropertiedObject.Property> propSet = new HashSet<PropertiedObject.Property>(Arrays.asList(props));
        ColumnPropertyMapping[] maps = classMap.getMappings();
        ArrayList<String> cols = new ArrayList<String>(maps.length - 1);
        for (int i = 0; i < maps.length; ++i) {
            ColumnPropertyMapping map = maps[i];
            if (map instanceof IDMapping || !propSet.contains(map.getProperty())) continue;
            cols.add(map.getCol());
        }
        return cols.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObject(PersistentObjDescriptor toDelete, DBConnectionInterface conn) throws Exception {
        if (this.deleteSQL == null) {
            AbstractQueryableColumnClassMap abstractQueryableColumnClassMap = this;
            synchronized (abstractQueryableColumnClassMap) {
                this.deleteSQL = SQL.delete(this.getTable());
            }
        }
        Object[] params = new Object[]{toDelete.getID()};
        conn.execute(this.deleteSQL, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChanged(PersistentObjectSnapshot toCheck, DBConnectionInterface conn) throws Exception {
        boolean different;
        block9: {
            if (this.changedSQL == null) {
                AbstractQueryableColumnClassMap abstractQueryableColumnClassMap = this;
                synchronized (abstractQueryableColumnClassMap) {
                    this.changedSQL = "SELECT " + this.getTable() + ".* FROM " + this.getTable() + " WHERE " + this.getColumn(PersistentObject.Properties.ID) + " = ?";
                }
            }
            different = false;
            ResultSet rs = conn.executeQuery(this.changedSQL, toCheck.getID());
            try {
                if (rs.next()) {
                    ColumnPropertyMapping[] mappings = this.getMappings();
                    for (int i = 0; i < mappings.length && !different; ++i) {
                        ColumnPropertyMapping mapping = mappings[i];
                        different = mapping.hasChanged(mapping.getDBValueFromSnapshot(toCheck), mapping.getFromResultSet(rs));
                        if (!Config.isDebuging() || !different) continue;
                        Object objectVal = mapping.getDBValueFromSnapshot(toCheck);
                        Object dbVal = mapping.getFromResultSet(rs);
                        OrderMateLog.LOG.info("Has changed was different for :" + this.getClass().getSimpleName() + " on index: " + i + " prop:" + mapping.getProperty() + ",  ObjVal: " + objectVal + ",  dbVal: " + dbVal);
                    }
                    break block9;
                }
                throw new IllegalStateException("Cannot find " + toCheck.getObjectType() + " with ID " + toCheck.getID() + " in DB with SQL " + this.changedSQL);
            }
            finally {
                conn.release(rs);
            }
        }
        return different;
    }

    @Override
    public void preload(PersistentObjectI toPreload) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColumnPropertyMapping[] getMappings() {
        if (!this.mappingsSetup) {
            AbstractQueryableColumnClassMap abstractQueryableColumnClassMap = this;
            synchronized (abstractQueryableColumnClassMap) {
                ColumnPropertyMapping[] colMaps = this.addModCountMapping(this.getRawMappings());
                for (int i = 0; i < colMaps.length; ++i) {
                    ColumnPropertyMapping currentMap = colMaps[i];
                    currentMap.setTable(this.getTable());
                }
                this.mappings = colMaps;
                this.mappingsSetup = true;
            }
        }
        return this.mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertiedObject.Property[] getWritableProperties() {
        if (this.writableProperties == null) {
            AbstractQueryableColumnClassMap abstractQueryableColumnClassMap = this;
            synchronized (abstractQueryableColumnClassMap) {
                this.writableProperties = AbstractQueryableColumnClassMap.getWritableProperties(this);
            }
        }
        return this.writableProperties;
    }

    public static PropertiedObject.Property[] getWritableProperties(QueryableColumnClassMap classMap) {
        ColumnPropertyMapping[] maps = classMap.getMappings();
        ArrayList<PropertiedObject.Property> writablePropertyList = new ArrayList<PropertiedObject.Property>(maps.length);
        for (int i = 0; i < maps.length; ++i) {
            ColumnPropertyMapping map = maps[i];
            if (map.isReadOnly()) continue;
            writablePropertyList.add(map.getProperty());
        }
        return writablePropertyList.toArray(new PropertiedObject.Property[writablePropertyList.size()]);
    }

    protected Object[] fillOutParamsArray(PersistentObjectSnapshot source, Object[] array, String[] cols, int arrayOffset) throws Exception {
        return AbstractQueryableColumnClassMap.fillOutParamsArray(this, source, array, cols, arrayOffset);
    }

    protected static Object[] fillOutParamsArray(QueryableColumnClassMap classMap, PersistentObjectSnapshot source, Object[] array, String[] cols, int arrayOffset) throws Exception {
        HashSet<String> colSet = new HashSet<String>(Arrays.asList(cols));
        ColumnPropertyMapping[] maps = classMap.getMappings();
        int paramsPos = arrayOffset;
        for (int i = 0; i < maps.length; ++i) {
            Object val;
            ColumnPropertyMapping map = maps[i];
            if (map instanceof IDMapping || map instanceof DiscriminatorColumnMapping || map instanceof VersionMapping || !colSet.contains(map.getCol())) continue;
            array[paramsPos] = val = map.getDBValueFromSnapshot(source);
            ++paramsPos;
            colSet.remove(map.getCol());
        }
        return array;
    }

    private void checkVersion(PersistentObjectSnapshot toUpdate, DBConnectionInterface conn) throws OptimisticLockException, Exception {
        Integer version = toUpdate.getVersion();
        String checkVersion = SQL.select(new String[]{"Version"}, this.objectTable, new String[]{"ID = " + toUpdate.getID()});
        ResultSet rs = conn.executeQuery(checkVersion);
        if (!rs.next()) {
            this.unlockTable(conn);
            conn.release(rs);
            return;
        }
        Integer newVersion = (Integer)rs.getObject(1);
        conn.release(rs);
        if (!newVersion.equals(version)) {
            this.unlockTable(conn);
            throw new OptimisticLockException("The record ID " + toUpdate.getID() + " has changed in the table " + this.objectTable + ". The version is now " + newVersion + " and you are updating from version " + version + ".", null, toUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockTable(DBConnectionInterface conn) throws SQLException, UnsupportedOperationException {
        if (this.lockSQL == null) {
            AbstractQueryableColumnClassMap abstractQueryableColumnClassMap = this;
            synchronized (abstractQueryableColumnClassMap) {
                this.lockSQL = SQL.lock(this.getTable());
                this.unlockSQL = SQL.unlock();
            }
        }
        conn.execute(this.lockSQL);
    }

    private void unlockTable(DBConnectionInterface conn) throws SQLException {
        conn.execute(this.unlockSQL);
    }

    @Override
    public boolean supportsQueries() {
        return true;
    }
}

