/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.database.AbstractClassMap;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.MappingUtils;
import au.com.ordermate.persistence.database.QueryableClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import au.com.ordermate.persistence.database.columnpropertymap.RowPropertyMapping;
import au.com.ordermate.sql.SQL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ordermate.database.DBConnectionInterface;

public abstract class AbstractRowClassMap
extends AbstractClassMap
implements QueryableClassMap {
    private Map<PropertiedObject.Property, RowPropertyMapping> mappedByProperty;
    private String keyColName;
    private String valueColName;
    private String table;

    public AbstractRowClassMap(String tableName, Class clazz) {
        this(tableName, clazz, "name", "value");
    }

    public AbstractRowClassMap(String newTableName, Class clazz, String newKeyColName, String newValueColName) {
        super(clazz);
        if (!PersistentObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Row class map can only map subclasses of PersistentObject");
        }
        this.keyColName = newKeyColName;
        this.valueColName = newValueColName;
        this.table = newTableName;
    }

    public abstract RowPropertyMapping[] getRawMappings();

    protected RowPropertyMapping[] getMappings() {
        if (!this.mappingsSetup) {
            RowPropertyMapping[] mapings = this.getRawMappings();
            for (int i = 0; i < mapings.length; ++i) {
                RowPropertyMapping currentMap = mapings[i];
                currentMap.setCol(this.getValueColName());
                currentMap.setTable(this.getTable());
            }
            this.mappingsSetup = true;
        }
        return this.getRawMappings();
    }

    private RowPropertyMapping getMapping(PropertiedObject.Property property) {
        if (this.mappedByProperty == null) {
            this.mappedByProperty = new HashMap<PropertiedObject.Property, RowPropertyMapping>();
            RowPropertyMapping[] mapings = this.getMappings();
            for (int i = 0; i < mapings.length; ++i) {
                RowPropertyMapping currentMap = mapings[i];
                this.mappedByProperty.put(currentMap.getProperty(), currentMap);
            }
        }
        return this.mappedByProperty.get(property);
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public PersistentList createList(PropertiedObject.Property property) throws Exception {
        throw new UnsupportedOperationException("Row mapped classes may not contain lists");
    }

    @Override
    public Reference createReference(PropertiedObject.Property property) throws Exception {
        RowPropertyMapping mapping = this.getMapping(property);
        if (mapping == null) {
            throw new Exception("Cannot find mapping for property " + property);
        }
        if (!(mapping instanceof ReferenceMapping)) {
            throw new Exception(property + " is not mapped by a reference");
        }
        ReferenceMapping refMap = (ReferenceMapping)mapping;
        return refMap.createReference();
    }

    private final String getKeyColName() {
        return this.keyColName;
    }

    private final String getValueColName() {
        return this.valueColName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getObjectList(String query, Object[] params, DBConnectionInterface conn) throws Exception {
        HashMap<String, RowPropertyMapping> mappedByDbKey = new HashMap<String, RowPropertyMapping>();
        RowPropertyMapping[] maps = this.getMappings();
        for (int i = 0; i < maps.length; ++i) {
            RowPropertyMapping mapping = maps[i];
            mappedByDbKey.put(mapping.getDbKey().toUpperCase(), mapping);
        }
        PersistentObject object = (PersistentObject)this.createRawObject();
        String sql = "SELECT * FROM " + this.getTable();
        ResultSet rs = conn.executeQuery(sql, new Object[0]);
        try {
            while (rs.next()) {
                String key = SQL.supportsTableNameColumnSelection() ? rs.getString(this.getTable() + "." + this.getKeyColName()).toUpperCase() : rs.getString(this.getKeyColName()).toUpperCase();
                RowPropertyMapping map = (RowPropertyMapping)mappedByDbKey.get(key);
                if (map == null) continue;
                Object value = map.getFromResultSet(rs);
                map.setObjectFieldFromDBValue(object, value);
            }
            PersistenceManager.setID(object, -1L);
            object.init();
            ArrayList<PersistentObject> list = new ArrayList<PersistentObject>();
            list.add(object);
            ArrayList<PersistentObject> arrayList = list;
            return arrayList;
        }
        finally {
            conn.release(rs);
        }
    }

    @Override
    public long insertObject(PersistentObjectSnapshot toInsert, DBConnectionInterface conn) throws Exception {
        this.updateObject(toInsert, (PropertiedObject.Property[])null, conn);
        return -1L;
    }

    public void updateObject(PersistentObjectSnapshot toUpdate, PropertiedObject.Property[] showProperties, DBConnectionInterface conn) throws Exception {
        HashSet<Object> propertiesSet;
        if (showProperties != null) {
            propertiesSet = new HashSet<PropertiedObject.Property>(Arrays.asList(showProperties));
        } else {
            propertiesSet = new HashSet();
            RowPropertyMapping[] maps = this.getMappings();
            for (int i = 0; i < maps.length; ++i) {
                propertiesSet.add(maps[i].getProperty());
            }
        }
        String updateSQL = "INSERT INTO " + this.getTable() + " ( " + this.getValueColName() + "," + this.getKeyColName() + ") VALUES (? , ?)  ON DUPLICATE KEY UPDATE value = ?, mod_count = mod_count + 1";
        RowPropertyMapping[] maps = this.getMappings();
        for (int i = 0; i < maps.length; ++i) {
            RowPropertyMapping map = maps[i];
            if (!propertiesSet.contains(map.getProperty())) continue;
            conn.execute(updateSQL, map.getDBValueFromSnapshot(toUpdate), map.getDbKey(), map.getDBValueFromSnapshot(toUpdate));
        }
    }

    @Override
    public void deleteObject(PersistentObjDescriptor toDelete, DBConnectionInterface conn) throws Exception {
        throw new UnsupportedOperationException("Cannot delete row class mapped objects");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChanged(PersistentObjectSnapshot toCheck, DBConnectionInterface conn) throws Exception {
        String sql = "SELECT * FROM " + this.getTable();
        ResultSet rs = conn.executeQuery(sql, new Object[0]);
        try {
            boolean different = false;
            while (rs.next() && !different) {
                Object objectVal;
                String key = SQL.supportsTableNameColumnSelection() ? rs.getString(this.getTable() + "." + this.getKeyColName()).toUpperCase() : rs.getString(this.getKeyColName()).toUpperCase();
                RowPropertyMapping obj = this.getMapping(new PropertiedObject.Property((Class<? extends PropertiedObject>)this.getTypeClass(), key));
                if (obj == null) continue;
                RowPropertyMapping map = obj;
                Object value = map.getFromResultSet(rs);
                different = !MappingUtils.equalsNullSafe(value, objectVal = map.getDBValueFromSnapshot(toCheck));
            }
            boolean bl = different;
            return bl;
        }
        finally {
            conn.release(rs);
        }
    }

    @Override
    public PropertyMapping[] getPropertyMappings() {
        return this.getMappings();
    }

    @Override
    public ListMapping[] getListMappings() {
        return new ListMapping[0];
    }

    @Override
    public ClassMap getLockableClassMap() {
        return this;
    }

    @Override
    public boolean supportsQueries() {
        return true;
    }
}

