/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.AbstractQueryableColumnClassMap;
import au.com.ordermate.persistence.database.AbstractSuperClassMap;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.SubClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.util.LangUtils;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import ordermate.database.DBConnectionInterface;

public abstract class AbstractSubClassMap
extends AbstractQueryableColumnClassMap
implements SubClassMap {
    private String[] cols;
    private String discrimValue;
    private AbstractSuperClassMap superMap;
    private String insertSQL;
    private String updateSQL;

    public AbstractSubClassMap(AbstractSuperClassMap superClassMap, PersistentEnumeration discrimVal, Class clazz) {
        this(superClassMap, discrimVal.toString(), clazz);
    }

    public AbstractSubClassMap(AbstractSuperClassMap superClassMap, Enum discrimVal, Class clazz) {
        this(superClassMap, discrimVal.toString(), clazz);
    }

    public AbstractSubClassMap(AbstractSuperClassMap superClassMap, String discrimVal, Class clazz) {
        super(superClassMap.getTable(), clazz);
        this.superMap = superClassMap;
        this.discrimValue = discrimVal;
        this.superMap.addSubClassMap(this, this.discrimValue);
    }

    @Override
    public AbstractSuperClassMap getSuperClassMap() {
        return this.superMap;
    }

    @Override
    public String getDiscriminatorValue() {
        return this.discrimValue;
    }

    @Override
    public PersistentObjectI createFromResultSet(ResultSet rs) throws Exception {
        String typeVal = SQL.supportsTableNameColumnSelection() ? rs.getString(this.getTable() + "." + this.getSuperClassMap().getDiscriminatorColumn()) : rs.getString(this.getSuperClassMap().getDiscriminatorColumn());
        if (this.getDiscriminatorValue() != null && !typeVal.equalsIgnoreCase(this.getDiscriminatorValue())) {
            throw new IllegalArgumentException("ResultSet contains data for object of type " + typeVal + " however this mapping deals with objects of type " + this.getDiscriminatorValue());
        }
        return super.createFromResultSet(rs);
    }

    @Override
    public final ColumnPropertyMapping[] getRawMappings() {
        ColumnPropertyMapping[] subArray = this.getSubClassMappings();
        ColumnPropertyMapping[] superArray = this.superMap.getSuperClassMappings();
        ColumnPropertyMapping[] combined = LangUtils.joinArrays(subArray, superArray, ColumnPropertyMapping.class);
        for (int i = 0; i < combined.length; ++i) {
            combined[i].setTable(this.getTable());
        }
        return combined;
    }

    @Override
    public final ListMapping[] getListMappings() {
        ListMapping[] subArray = this.getSubClassListMappings();
        ListMapping[] superArray = this.superMap.getSuperClassListMappings();
        int newLength = subArray.length + superArray.length;
        Object[] combinedArrays = (Object[])Array.newInstance(ListMapping.class, newLength);
        System.arraycopy(subArray, 0, combinedArrays, 0, subArray.length);
        System.arraycopy(superArray, 0, combinedArrays, subArray.length, superArray.length);
        return (ListMapping[])combinedArrays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertObject(PersistentObjectSnapshot toInsert, DBConnectionInterface conn) throws Exception {
        if (this.insertSQL == null) {
            AbstractSubClassMap abstractSubClassMap = this;
            synchronized (abstractSubClassMap) {
                this.cols = this.getCols();
                if (this.getIdGenerationStrategy() != null) {
                    String[] newCols = new String[this.cols.length + 1];
                    System.arraycopy(this.cols, 0, newCols, 0, this.cols.length);
                    newCols[this.cols.length] = "ID";
                    this.cols = newCols;
                }
                this.insertSQL = SQL.insert(this.getTable(), this.getCols());
            }
        }
        Object[] params = AbstractQueryableColumnClassMap.fillOutParamsArray(this, toInsert, new Object[this.getCols().length], this.getCols(), 1);
        params[0] = this.getDiscriminatorValue();
        if (this.getIdGenerationStrategy() != null) {
            params[params.length - 1] = toInsert.getID() == null ? this.getIdGenerationStrategy().generateNextId(conn) : toInsert.getID();
        }
        long id = conn.executeInsert(this.insertSQL, params);
        return id;
    }

    @Override
    public void updateObject(PersistentObjectSnapshot<?> toUpdate, PropertiedObject.Property[] showPropertiesParam, DBConnectionInterface conn) throws Exception {
        SubClassMap.SubClassMapHelper.updateObject(this, toUpdate, showPropertiesParam, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getCols() {
        if (this.cols == null) {
            AbstractSubClassMap abstractSubClassMap = this;
            synchronized (abstractSubClassMap) {
                this.cols = SubClassMap.SubClassMapHelper.getCols(this);
            }
        }
        return this.cols;
    }

    @Override
    public void preload(PersistentObjectI toPreload) {
        this.superMap.preload(toPreload);
    }

    protected abstract ColumnPropertyMapping[] getSubClassMappings();

    protected ListMapping[] getSubClassListMappings() {
        return new ListMapping[0];
    }

    @Override
    public ClassMap getLockableClassMap() {
        return this.getSuperClassMap().getLockableClassMap();
    }
}

