/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.ColumnClassMap;
import au.com.ordermate.persistence.database.MappingUtils;
import au.com.ordermate.persistence.database.QueryableClassMap;
import au.com.ordermate.persistence.database.SubClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PropertyMapping;
import au.com.ordermate.sql.SQL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.DBConnectionInterface;

public abstract class AbstractSuperClassMap
implements QueryableClassMap,
ColumnClassMap {
    private Map<Class, SubClassMap> subMapsByClass;
    private boolean mappingsSetup;
    private Map<Object, SubClassMap> subMapsByDiscriminator;
    private final String objectTable;
    private final Class objectClass;

    public AbstractSuperClassMap(String table, Class clazz) {
        this.objectTable = table;
        this.objectClass = clazz;
    }

    public abstract String getDiscriminatorColumn();

    protected abstract ColumnPropertyMapping[] getRawSuperClassMappings();

    @Override
    public final String getColumn(PropertiedObject.Property property) {
        return MappingUtils.getColForProperty(property, this.getSuperClassMappings());
    }

    @Override
    public final String getTable() {
        return this.objectTable;
    }

    protected ListMapping[] getSuperClassListMappings() {
        return new ListMapping[0];
    }

    @Override
    public final Class getTypeClass() {
        return this.objectClass;
    }

    @Override
    public PersistentList createList(PropertiedObject.Property property) throws Exception {
        return MappingUtils.createList(property, this.getSuperClassListMappings());
    }

    @Override
    public Reference createReference(PropertiedObject.Property property) throws Exception {
        return MappingUtils.createReference(property, this.getSuperClassMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getObjectList(String query, Object[] params, DBConnectionInterface conn) throws Exception {
        ResultSet rs = conn.executeQuery(query, params);
        try {
            ArrayList<PersistentObjectI> objects = new ArrayList<PersistentObjectI>(rs.getFetchSize());
            while (rs.next()) {
                SubClassMap map = this.getSubClassMap(rs);
                PersistentObjectI created = map.createFromResultSet(rs);
                objects.add(created);
            }
            ArrayList<PersistentObjectI> arrayList = objects;
            return arrayList;
        }
        finally {
            conn.release(rs);
        }
    }

    @Override
    public long insertObject(PersistentObjectSnapshot toInsert, DBConnectionInterface conn) throws Exception {
        SubClassMap map = this.getSubClassMap(toInsert.getObjectType());
        return map.insertObject(toInsert, conn);
    }

    public void updateObject(PersistentObjectSnapshot toUpdate, PropertiedObject.Property[] properties, DBConnectionInterface conn) throws Exception {
        SubClassMap map = this.getSubClassMap(toUpdate.getObjectType());
        map.updateObject(toUpdate, properties, conn);
    }

    @Override
    public void deleteObject(PersistentObjDescriptor toDelete, DBConnectionInterface conn) throws Exception {
        SubClassMap map = this.getSubClassMap(toDelete.getObjectType());
        map.deleteObject(toDelete, conn);
    }

    @Override
    public boolean hasChanged(PersistentObjectSnapshot toCheck, DBConnectionInterface conn) throws Exception {
        SubClassMap map = this.getSubClassMap(toCheck.getObjectType());
        return map.hasChanged(toCheck, conn);
    }

    @Override
    public void preload(PersistentObjectI toLoad) {
    }

    public ColumnPropertyMapping[] getSuperClassMappings() {
        if (!this.mappingsSetup) {
            ColumnPropertyMapping[] mapings = this.getRawSuperClassMappings();
            for (int i = 0; i < mapings.length; ++i) {
                ColumnPropertyMapping currentMap = mapings[i];
                currentMap.setTable(this.getTable());
            }
            this.mappingsSetup = true;
        }
        return this.getRawSuperClassMappings();
    }

    private SubClassMap getSubClassMap(ResultSet rs) throws SQLException {
        Object discrimVal = SQL.supportsTableNameColumnSelection() ? rs.getObject(this.getTable() + "." + this.getDiscriminatorColumn()) : rs.getObject(this.getDiscriminatorColumn());
        if (!this.subMapsByDiscriminator.containsKey(discrimVal)) {
            throw new IllegalArgumentException("No sub class map registered for " + discrimVal + " for super class : " + this.getClass().getSimpleName());
        }
        SubClassMap map = this.subMapsByDiscriminator.get(discrimVal);
        return map;
    }

    private SubClassMap getSubClassMap(Class theClass) {
        if (!this.subMapsByClass.containsKey(theClass)) {
            throw new IllegalArgumentException("No sub class map registered for " + theClass);
        }
        SubClassMap map = this.subMapsByClass.get(theClass);
        return map;
    }

    @Override
    public ClassMap getLockableClassMap() {
        return this;
    }

    protected void addSubClassMap(SubClassMap map, Object discrimValue) {
        if (this.subMapsByClass == null) {
            this.subMapsByClass = new HashMap<Class, SubClassMap>();
            this.subMapsByDiscriminator = new HashMap<Object, SubClassMap>();
        }
        if (this.subMapsByDiscriminator.containsKey(discrimValue)) {
            throw new IllegalArgumentException("Mapping already exists for this discriminator value : " + discrimValue);
        }
        this.subMapsByDiscriminator.put(discrimValue, map);
        this.subMapsByClass.put(map.getClass(), map);
    }

    @Override
    public PropertyMapping[] getPropertyMappings() {
        return this.getSuperClassMappings();
    }

    @Override
    public ListMapping[] getListMappings() {
        return this.getSuperClassListMappings();
    }

    @Override
    public boolean isVersioned() {
        return false;
    }

    @Override
    public boolean supportsQueries() {
        return true;
    }

    @Override
    public Map<String, ?> getMetadata(PropertiedObject.Property property) {
        return MappingUtils.getMetadataForProperty(property, this.getSuperClassMappings());
    }
}

