/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.persistence.PersistentObjectSnapshotDiff;
import au.com.ordermate.persistence.database.PersistInterceptorGWWorker;
import javax.jms.IllegalStateException;
import ordermate.OrderMate;
import ordermate.observers.PersistenceChangeListener;

public class AsyncPersistenceInterceptorGateway {
    private final Gateway<PersistentObjectSnapshotDiff> gateway;
    private static AsyncPersistenceInterceptorGateway gatewayInterceptor;
    private final PersistInterceptorGWWorker persistenceInterceptor = new PersistInterceptorGWWorker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncPersistenceInterceptorGateway() {
        Gateway<PersistentObjectSnapshotDiff> gateway = this.gateway = new Gateway<PersistentObjectSnapshotDiff>(this.persistenceInterceptor, new DiffNotifier(), 1000);
        synchronized (gateway) {
            this.gateway.startService();
        }
    }

    public static final AsyncPersistenceInterceptorGateway getInstance() {
        return gatewayInterceptor;
    }

    static final synchronized void init() throws IllegalStateException {
        if (gatewayInterceptor != null) {
            throw new IllegalStateException("The persistence gateway interceptor can only be initiated once!");
        }
        gatewayInterceptor = new AsyncPersistenceInterceptorGateway();
    }

    public void registerListenersOnGateway(PersistenceChangeListener listener) {
        this.persistenceInterceptor.registerListener(listener);
    }

    public void deregisterListenersOnGateway(PersistenceChangeListener listener) {
        this.persistenceInterceptor.deRegisterListener(listener);
    }

    public void processDiff(PersistentObjectSnapshotDiff snapShotDiff) {
        if (this.persistenceInterceptor.isRelevantClass(snapShotDiff.getClassType())) {
            this.gateway.putIntoQueue(snapShotDiff);
        }
    }

    public int getQueueSize() {
        return this.gateway.getIncomingQueue().size();
    }

    class DiffNotifier
    implements GatewayNotifier<PersistentObjectSnapshotDiff> {
        private static final long WAIT_TIME = 10L;

        DiffNotifier() {
        }

        @Override
        public void notifyProcess(PersistentObjectSnapshotDiff processedValue, boolean processSuccessful) {
            if (processedValue != PersistentObjectSnapshotDiff.ALL_DONE && AsyncPersistenceInterceptorGateway.this.gateway.getIncomingQueue().size() == 0) {
                try {
                    boolean theEnd = true;
                    int i = 0;
                    while ((long)i < 10L) {
                        if (AsyncPersistenceInterceptorGateway.this.gateway.getIncomingQueue().size() != 0) {
                            theEnd = false;
                            break;
                        }
                        Thread.sleep(1L);
                        ++i;
                    }
                    if (theEnd) {
                        AsyncPersistenceInterceptorGateway.this.gateway.putIntoQueue(PersistentObjectSnapshotDiff.ALL_DONE);
                    }
                }
                catch (InterruptedException e) {
                    AsyncPersistenceInterceptorGateway.this.gateway.putIntoQueue(PersistentObjectSnapshotDiff.ALL_DONE);
                }
            }
            if (!processSuccessful) {
                OrderMate.LOG.error("Error happened while saving diffs for: " + processedValue.toString());
            }
        }
    }
}

