/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.database.datasourcefactory.DataSourceFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import ordermate.dbconnection.AbstractDatabaseConnection;

public class DatabaseConnection
extends AbstractDatabaseConnection {
    private DataSource datasource;

    @Override
    public String getDatabaseName() {
        return Config.getStringValue("database_name");
    }

    public DatabaseConnection(DataSourceFactory dsFactory) {
        try {
            this.datasource = dsFactory.constructDataSource();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Could not construct database connection: ", ex);
        }
    }

    @Override
    public Connection getDBConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    @Override
    public void reconnect() throws SQLException {
    }

    @Override
    public void release(ResultSet set) throws SQLException {
        if (set == null) {
            return;
        }
        Statement statement = set.getStatement();
        Connection connection = null;
        if (statement != null) {
            connection = statement.getConnection();
        }
        set.close();
        this.release(statement, connection);
        if (connection == null) {
            OrderMateLog.LOG.warn("Null connection, was not closed");
        }
    }

    @Override
    protected void release(Statement statement, Connection connection) throws SQLException {
        if (statement != null) {
            statement.close();
        }
        if (connection != null && !connection.isClosed()) {
            connection.close();
        }
    }
}

