/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.ComponentFactory;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PersistentObjectSnapshotDiff;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.UnsafePersistence;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.cache.remote.RemoteCachePublisher;
import au.com.ordermate.persistence.database.AbstractSuperClassMap;
import au.com.ordermate.persistence.database.AsyncPersistenceInterceptorGateway;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.ColumnClassMap;
import au.com.ordermate.persistence.database.DiscriminatorMap;
import au.com.ordermate.persistence.database.LPAPersistenceMetaData;
import au.com.ordermate.persistence.database.QueryableClassMap;
import au.com.ordermate.persistence.database.SubClassMap;
import au.com.ordermate.persistence.database.datasourcefactory.DataSourceFactory;
import au.com.ordermate.util.DateTimeUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.diff.VersionDiff;
import ordermate.dbconnection.AbstractDatabaseConnection;

public class DatabasePersistence
implements UnsafePersistence {
    private final Object mutex = new Object();
    private RemoteCachePublisher invalidateCachePublisher;
    private LPAPersistenceMetaData persistenceMappings;
    private ComponentFactory persistenceFactory;
    private DataSourceFactory dsFactory;
    private boolean cacheConnections = false;
    private List<AbstractDatabaseConnection> connectionPool;
    private AbstractDatabaseConnection singleConnection;
    private int maxConnections = 20;
    private AsyncPersistenceInterceptorGateway persistIntGW;

    public DatabasePersistence() {
        this(null);
    }

    public DatabasePersistence(DataSourceFactory dsFactory) {
        this.dsFactory = dsFactory;
        this.connectionPool = new ArrayList<AbstractDatabaseConnection>();
        this.initPersistIntGW();
        this.cacheConnections = Config.getBooleanValue("DB_CACHE_CONNECTIONS");
    }

    public <T extends ComponentFactory & LPAPersistenceMetaData> void initialize(T delegate) {
        this.persistenceMappings = delegate;
        this.persistenceFactory = delegate;
        this.initPersistIntGW();
    }

    private void initPersistIntGW() {
        if (AsyncPersistenceInterceptorGateway.getInstance() == null) {
            try {
                AsyncPersistenceInterceptorGateway.init();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error in AsyncPersistenceInterceptorGateway init.", (Throwable)ex);
            }
        }
        this.persistIntGW = AsyncPersistenceInterceptorGateway.getInstance();
    }

    public LPAPersistenceMetaData getPersistenceMetaData() {
        return this.persistenceMappings;
    }

    private QueryableClassMap getQueryableClassMap(Class type) throws IllegalArgumentException {
        if (!this.persistenceMappings.hasClassMap(type)) {
            OrderMate.LOG.debug("No mapping defined for type " + type);
            return null;
        }
        if (!(this.persistenceMappings.getClassMap(type) instanceof QueryableClassMap)) {
            OrderMate.LOG.debug("Mapped " + type + " is not a QueryableClassMap.");
            return null;
        }
        return (QueryableClassMap)this.persistenceMappings.getClassMap(type);
    }

    public boolean isQueryableClassMap(Class type) throws IllegalArgumentException {
        if (!this.persistenceMappings.hasClassMap(type)) {
            return false;
        }
        return this.persistenceMappings.getClassMap(type) instanceof QueryableClassMap;
    }

    protected AbstractDatabaseConnection getConnection() {
        if (!this.cacheConnections) {
            if (this.singleConnection == null) {
                this.singleConnection = this.createConnection();
            }
            return this.singleConnection;
        }
        return this.getCachedConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDatabaseConnection getCachedConnection() {
        AbstractDatabaseConnection connection = null;
        List<AbstractDatabaseConnection> list = this.connectionPool;
        synchronized (list) {
            for (AbstractDatabaseConnection nextConn : this.connectionPool) {
                if (nextConn.getLock().isHeldByCurrentThread() || !nextConn.getLock().isLocked()) {
                    return nextConn;
                }
                if (connection == null) {
                    connection = nextConn;
                }
                int length = nextConn.getLock().getQueueLength();
                if (nextConn.getLock().getQueueLength() >= length) continue;
                connection = nextConn;
            }
            if (connection == null || connection.getLock().hasQueuedThreads() && this.connectionPool.size() < this.maxConnections) {
                connection = this.createConnection();
                this.connectionPool.add(connection);
            }
        }
        return connection;
    }

    private AbstractDatabaseConnection createConnection() {
        this.singleConnection = this.dsFactory == null ? (AbstractDatabaseConnection)AbstractDatabaseConnection.getDBConnectionInterface() : (AbstractDatabaseConnection)AbstractDatabaseConnection.getDBConnectionInterface(this.dsFactory);
        this.startTimerForPingingConnection(this.singleConnection);
        return this.singleConnection;
    }

    private void startTimerForPingingConnection(final AbstractDatabaseConnection connection) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                OrderMate.LOG.info("DatabasePersistence Reconnection timer task is started...");
                DatabasePersistence.this.pingConnection(connection);
            }
        }, DateTimeUtils.addTime(new Date(), 10, 1), 3600000L);
    }

    public void ping() throws Exception {
        AbstractDatabaseConnection conn = this.getConnection();
        this.pingConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pingConnection(AbstractDatabaseConnection connection) {
        ResultSet rs = null;
        try {
            connection.getLock().lock();
            rs = connection.executeQuery("SELECT 1", new String[0]);
        }
        catch (SQLException sQLException) {
            try {
                connection.release(rs);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            connection.getLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            try {
                connection.release(rs);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connection.getLock().unlock();
            throw throwable;
        }
        try {
            connection.release(rs);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        connection.getLock().unlock();
    }

    @Override
    public PersistentList createList(PropertiedObject.Property property) throws Exception {
        return this.persistenceFactory.createList(property);
    }

    @Override
    public Reference createReference(PropertiedObject.Property property) throws Exception {
        return this.persistenceFactory.createReference(property);
    }

    @Override
    public PersistentObject preload(Class type, Long ID) throws Exception {
        String table = this.getClassTable(type);
        String idCol = this.getPropertyColumn(new PropertiedObject.Property((Class<? extends PropertiedObject>)type, PersistentObject.Properties.ID));
        assert (table != null) : "No table found for " + type;
        assert (idCol != null) : "No column found for ID into " + type;
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(table).append(".* FROM ").append(table).append(" WHERE ").append(idCol).append(" = ?");
        List objects = this.getObjectList(type, sql.toString(), new Object[]{ID}, null);
        PersistentObject toPreload = (PersistentObject)objects.get(0);
        ClassMap map = this.persistenceMappings.getClassMap(type);
        map.preload(toPreload);
        return toPreload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long saveOrUpdate(PersistentObjectSnapshot toSave) throws Exception {
        long retVal;
        PersistentObjectSnapshot snapshot = toSave;
        PersistentObjectSnapshot oldSnapshot = null;
        VersionDiff.ChangeType change = VersionDiff.ChangeType.Creation;
        if (toSave.isPersistent()) {
            oldSnapshot = this.getOldSnapShot(toSave);
            change = VersionDiff.ChangeType.Update;
        }
        QueryableClassMap map = this.getQueryableClassMap(toSave.getObjectType());
        boolean invalidateRequired = false;
        if (toSave.isPersistent()) {
            this.invalidateObject(toSave);
        }
        AbstractDatabaseConnection conn = this.getConnection();
        conn.getLock().lock();
        try {
            if (toSave.isPersistent()) {
                map.updateObject(toSave, null, conn);
                Long objectID = toSave.getID();
                invalidateRequired = true;
                retVal = objectID;
            } else {
                retVal = map.insertObject(toSave, conn);
                snapshot.add(PersistentObject.Properties.ID, retVal);
            }
        }
        finally {
            conn.getLock().unlock();
        }
        this.persistIntGW.processDiff(this.makeSnapshotDiff(oldSnapshot, snapshot, change));
        if (invalidateRequired) {
            this.invalidateObject(toSave);
            CacheManager.getInstance().cacheObject(toSave);
        }
        return retVal;
    }

    private void invalidateObject(PersistentObjectSnapshot toInvalidate) {
        CacheManager.getInstance().invalidateObject(new PersistentObjDescriptor(toInvalidate));
    }

    private void invalidateObject(PersistentObjDescriptor toInvalidate) {
        CacheManager.getInstance().invalidateObject(toInvalidate);
        if (this.invalidateCachePublisher != null) {
            this.invalidateCachePublisher.invalidateObject(toInvalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(PersistentObjectSnapshot toUpdate, PropertiedObject.Property[] properties) throws Exception {
        PersistentObjectSnapshot oldSnapshot = this.getOldSnapShot(toUpdate);
        this.persistIntGW.processDiff(this.makeSnapshotDiff(oldSnapshot, toUpdate, VersionDiff.ChangeType.Update));
        QueryableClassMap map = this.getQueryableClassMap(toUpdate.getObjectType());
        AbstractDatabaseConnection conn = this.getConnection();
        conn.getLock().lock();
        try {
            map.updateObject(toUpdate, properties, conn);
        }
        finally {
            conn.getLock().unlock();
        }
        this.invalidateObject(toUpdate);
    }

    private PersistentObjectSnapshot getOldSnapShot(PersistentObjectSnapshot snapshot) {
        PersistentObject saveObject = null;
        try {
            saveObject = (PersistentObject)PersistenceManager.getByID(snapshot.getID(), snapshot.getObjectType());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't get the old snapshot ID=" + snapshot.getID() + " " + snapshot.getObjectType().getSimpleName());
            try {
                saveObject = PersistenceManager.getByID(snapshot.getID(), snapshot.getObjectType().getSuperclass());
            }
            catch (Exception ex2) {
                OrderMate.LOG.error("Couldn't retrieve via superclass, either", (Throwable)ex);
            }
        }
        if (saveObject != null) {
            return saveObject.getSnapshot();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(PersistentObjDescriptor toDelete) throws Exception {
        if (!toDelete.isPersistent()) {
            return;
        }
        PersistentObjDescriptor descriptor = toDelete;
        Object persistentObj = descriptor.resolveObject();
        if (persistentObj != null) {
            descriptor = descriptor.createResolvedDescriptor((PersistentObject)persistentObj);
            this.persistIntGW.processDiff(this.makeSnapshotDiff(((PersistentObject)persistentObj).getSnapshot(), null, VersionDiff.ChangeType.Deletion));
        }
        QueryableClassMap map = this.getQueryableClassMap(descriptor.getObjectType());
        AbstractDatabaseConnection conn = this.getConnection();
        conn.getLock().lock();
        try {
            map.deleteObject(toDelete, conn);
        }
        finally {
            conn.getLock().unlock();
        }
        this.invalidateObject(descriptor);
    }

    private PersistentObjectSnapshotDiff makeSnapshotDiff(PersistentObjectSnapshot oldObj, PersistentObjectSnapshot newObj, VersionDiff.ChangeType change) {
        return new PersistentObjectSnapshotDiff(oldObj, newObj, change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChanged(PersistentObjectSnapshot toCheck) throws Exception {
        QueryableClassMap map = this.getQueryableClassMap(toCheck.getObjectType());
        AbstractDatabaseConnection conn = this.getConnection();
        conn.getLock().lock();
        try {
            boolean bl = map.hasChanged(toCheck, conn);
            return bl;
        }
        finally {
            conn.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getObjectList(Class type, String query, Object[] params, SessionI session) throws Exception {
        QueryableClassMap qClassMap = this.getQueryableClassMap(type);
        AbstractDatabaseConnection conn = this.getConnection();
        conn.getLock().lock();
        try {
            if (qClassMap != null && qClassMap.getLockableClassMap() != null) {
                List list = qClassMap.getObjectList(query, params, conn);
                return list;
            }
            ClassMap map = this.persistenceMappings.getClassMap(type);
            List list = map.getObjectList(query, params, conn);
            return list;
        }
        finally {
            conn.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[][] executeQuery(String sql, Object[] params) throws Exception {
        AbstractDatabaseConnection conn = this.getConnection();
        conn.getLock().lock();
        try {
            Object[][] objectArray;
            ResultSet rs = conn.executeQuery(sql, params);
            try {
                Object[][] results;
                int numColumns = rs.getMetaData().getColumnCount();
                LinkedList<Object[]> tempResults = new LinkedList<Object[]>();
                while (rs.next()) {
                    Object[] row = new Object[numColumns];
                    for (int x = 0; x < numColumns; ++x) {
                        row[x] = rs.getObject(x + 1);
                    }
                    tempResults.add(row);
                }
                objectArray = results = (Object[][])tempResults.toArray((T[])new Object[0][0]);
            }
            catch (Throwable throwable) {
                conn.release(rs);
                throw throwable;
            }
            conn.release(rs);
            return objectArray;
        }
        finally {
            conn.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeInsert(String sql, Object[] params) throws Exception {
        AbstractDatabaseConnection conn = this.getConnection();
        conn.getLock().lock();
        try {
            long l = conn.executeInsert(sql, params);
            return l;
        }
        finally {
            conn.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUpdate(String sql, Object[] params) throws Exception {
        AbstractDatabaseConnection conn = this.getConnection();
        conn.getLock().lock();
        try {
            conn.execute(sql, params);
        }
        finally {
            conn.getLock().unlock();
        }
    }

    @Override
    public String getClassTable(Class type) throws Exception {
        QueryableClassMap map = this.getQueryableClassMap(type);
        if (map == null) {
            return null;
        }
        return map.getTable();
    }

    @Override
    public String getPropertyColumn(PropertiedObject.Property property) throws Exception {
        QueryableClassMap map = this.getQueryableClassMap(property.getOwner());
        if (map == null) {
            return null;
        }
        if (map instanceof ColumnClassMap) {
            return ((ColumnClassMap)((Object)map)).getColumn(property);
        }
        OrderMate.LOG.debug(property.getOwner() + " does not implement the Column ClassMap interface");
        return null;
    }

    @Override
    public String getDiscriminatorColumn(Class type) throws Exception {
        QueryableClassMap map = this.getQueryableClassMap(type);
        if (map instanceof SubClassMap) {
            return ((SubClassMap)map).getSuperClassMap().getDiscriminatorColumn();
        }
        if (map instanceof AbstractSuperClassMap) {
            return ((AbstractSuperClassMap)map).getDiscriminatorColumn();
        }
        return null;
    }

    @Override
    public String getDiscriminatorValue(Class type) throws Exception {
        QueryableClassMap map = this.getQueryableClassMap(type);
        if (map instanceof DiscriminatorMap) {
            return ((DiscriminatorMap)((Object)map)).getDiscriminatorValue();
        }
        throw new IllegalArgumentException(type + " map does not extend DiscriminatorMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object runSync(Executable exec) throws Exception {
        Object object = this.mutex;
        synchronized (object) {
            OrderMate.LOG.info("Task " + exec + " DatabasePersistence:runSync() is locked");
            Object obj = exec.execute();
            OrderMate.LOG.info("Task " + exec + " DatabasePersistence:runSync() is unlocked");
            return obj;
        }
    }

    public void setInvalidateCachePublisher(RemoteCachePublisher newInvalidateCachePublisher) {
        this.invalidateCachePublisher = newInvalidateCachePublisher;
    }

    @Override
    public Map<String, ?> getPropertyMetadata(PropertiedObject.Property property) {
        QueryableClassMap map = this.getQueryableClassMap(property.getOwner());
        if (map instanceof ColumnClassMap) {
            return ((ColumnClassMap)((Object)map)).getMetadata(property);
        }
        return Collections.emptyMap();
    }
}

