/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.database.DatabasePersistence;
import au.com.ordermate.persistence.database.priority.DefaultPriorityAssigner;
import au.com.ordermate.persistence.database.priority.SnapshotPriorityAssigner;
import au.com.ordermate.persistence.synchronisation.SnapshotEntry;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ordermate.OrderMate;
import ordermate.dbconnection.AbstractDatabaseConnection;
import ordermate.hom.DbSnapshotBufferType;
import ordermate.hom.synchronisation.SnapshotBuffer;
import org.apache.activemq.util.ByteArrayInputStream;

public class DbSnapshotBuffer
implements SnapshotBuffer {
    private final DatabasePersistence persistence;
    private final SnapshotPriorityAssigner priorityAssigner;
    private static final String DELETE = "DELETE FROM system_synchronisation_buffer WHERE id = ";
    private static final String CLEAR = "DELETE FROM system_synchronisation_buffer";
    private static final String SELECT_BY_PRIORITY = "SELECT * FROM system_synchronisation_buffer WHERE (priority = ?) AND (snapshot_type = ?) ORDER BY id LIMIT 250";
    private static final String OPTIMIZE = "OPTIMIZE  TABLE system_synchronisation_buffer";
    private static final String MAX_PRIORITY = "SELECT MAX(priority) AS max_priority FROM system_synchronisation_buffer WHERE (snapshot_type = ?)";
    private static final String BULK_INSERT = "INSERT INTO system_synchronisation_buffer (object, priority, snapshot_type) VALUES ";
    private final HashMap<Integer, String> bulkInsertStatement = new HashMap();
    private final HashMap<String, PreparedStatement> preparedStatements = new HashMap();
    private volatile boolean usePreparedStatements = false;
    private final DbSnapshotBufferType type;

    public DbSnapshotBuffer(DbSnapshotBufferType type) {
        this.type = type;
        this.persistence = new DatabasePersistence();
        try {
            this.persistence.executeUpdate(OPTIMIZE, null);
        }
        catch (Exception e) {
            OrderMateLog.LOG.warn((Object)e);
        }
        this.priorityAssigner = new DefaultPriorityAssigner();
    }

    SnapshotPriorityAssigner getPriorityAssigner() {
        return this.priorityAssigner;
    }

    @Override
    public void setUsePreparedStatements(boolean b) {
        boolean oldValue = this.usePreparedStatements;
        if (!b && oldValue) {
            this.closePreparedStatements();
        }
        this.usePreparedStatements = b;
    }

    @Override
    public void add(SynchronisationSnapshot ... snapshot) throws Exception {
        if (snapshot == null || snapshot.length == 0) {
            throw new IllegalArgumentException("Cannot add null or empty snapshots");
        }
        Object[] snapshotData = this.buildSnapshotData(snapshot);
        if (Config.isDebuging()) {
            for (int i = 0; i < snapshotData.length; ++i) {
                if (snapshotData[i] != null) continue;
                throw new IllegalArgumentException("Snapshot should not be null, index : " + i);
            }
        }
        if (this.usePreparedStatements) {
            PreparedStatement statement = this.getPreparedStatement(this.getBulkInsertStmt(snapshotData.length, this.type));
            for (int i = 1; i <= snapshotData.length; ++i) {
                statement.setObject(i, snapshotData[i - 1]);
            }
            statement.execute();
        } else {
            this.persistence.executeInsert(this.getBulkInsertStmt(snapshotData.length, this.type), snapshotData);
        }
    }

    private Object[] buildSnapshotData(SynchronisationSnapshot[] snapshot) {
        ArrayList<Serializable> toReturn = new ArrayList<Serializable>();
        for (SynchronisationSnapshot snappy : snapshot) {
            toReturn.add(snappy);
            toReturn.add(Integer.valueOf(this.priorityAssigner.assignPriority(snappy)));
        }
        return toReturn.toArray();
    }

    private void closePreparedStatements() {
        if (!this.usePreparedStatements) {
            throw new IllegalStateException("Not using prepared statements");
        }
        for (PreparedStatement stmt : this.preparedStatements.values()) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                OrderMate.LOG.warn("Exception clossing prepared statment", (Throwable)ex);
            }
        }
        this.preparedStatements.clear();
    }

    private String getBulkInsertStmt(int passedInSize, DbSnapshotBufferType snapshotType) {
        int numParams = passedInSize / 2;
        if (numParams == 0) {
            throw new IllegalArgumentException("Need some parameters for inserting");
        }
        String cachedStatement = this.bulkInsertStatement.get(numParams);
        if (cachedStatement != null) {
            return cachedStatement;
        }
        StringBuilder insert = new StringBuilder(BULK_INSERT).append(" (");
        for (int i = 0; i < numParams; ++i) {
            insert.append("?, ?, '").append(snapshotType.toString()).append("')");
            if (i >= numParams - 1) continue;
            insert.append(",(");
        }
        this.bulkInsertStatement.put(numParams, insert.toString());
        return insert.toString();
    }

    @Override
    public void remove(List<SnapshotEntry> entries) throws Exception {
        for (SnapshotEntry entry : entries) {
            this.persistence.executeUpdate(DELETE + entry.getId(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SnapshotEntry> getBufferContent() throws Exception {
        Object[][] results;
        ArrayList<SnapshotEntry> entries = new ArrayList<SnapshotEntry>();
        int highestPriority = this.getHighestPriorityInTable(this.type);
        for (Object[] result : results = this.persistence.executeQuery(SELECT_BY_PRIORITY, new Object[]{highestPriority, this.type.toString()})) {
            long entryID = (Long)result[0];
            byte[] bytes = (byte[])result[1];
            try (ObjectInputStream stream = null;){
                stream = new ObjectInputStream((InputStream)new ByteArrayInputStream(bytes));
                SynchronisationSnapshot snapshot = (SynchronisationSnapshot)stream.readObject();
                SnapshotEntry entry = new SnapshotEntry();
                entry.setSnapshot(snapshot);
                entry.setId(entryID);
                entry.setPriority(highestPriority);
                entry.setSnapshotType(this.type);
                entries.add(entry);
            }
        }
        return entries;
    }

    private int getHighestPriorityInTable(DbSnapshotBufferType snapshotType) throws Exception {
        Object[][] results = this.persistence.executeQuery(MAX_PRIORITY, new Object[]{snapshotType.toString()});
        Integer maxPriority = (Integer)(results.length > 0 && results[0].length > 0 ? results[0][0] : null);
        return maxPriority == null ? 4 : maxPriority;
    }

    @Override
    public void clear() throws Exception {
        this.persistence.executeUpdate(this.appendType(CLEAR), null);
    }

    private String appendType(String toAppend) {
        return toAppend + " WHERE snapshot_type = '" + this.type.name() + "'";
    }

    private PreparedStatement getPreparedStatement(String insertStmt) {
        if (this.preparedStatements.get(insertStmt) == null) {
            try {
                AbstractDatabaseConnection conn = this.persistence.getConnection();
                try {
                    conn.getLock().lock();
                    this.preparedStatements.put(insertStmt, conn.getDBConnection().prepareStatement(insertStmt));
                }
                finally {
                    conn.getLock().unlock();
                }
            }
            catch (SQLException ex) {
                OrderMate.LOG.error("Error preparing statement for snapshot buffer", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return this.preparedStatements.get(insertStmt);
    }
}

