/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.ComponentFactory;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.FKList;
import au.com.ordermate.persistence.Persistence;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistenceException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.ServerConnection;
import au.com.ordermate.persistence.SessionI;
import au.com.ordermate.persistence.UnsafePersistenceWrapper;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.DatabasePersistence;
import au.com.ordermate.persistence.database.LPAPersistenceMetaData;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PropertyMapping;
import au.com.ordermate.persistence.list.QueryList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import ordermate.database.misc.HOConfig;

public class LPAPersistenceDelegate
implements PersistenceDelegate,
ComponentFactory,
LPAPersistenceMetaData,
ServerConnection {
    private final Persistence persistence;
    private final Map<Class, ClassMap> mappings = new HashMap<Class, ClassMap>();
    private static final boolean PROFILE_PRELOAD = false;
    private AtomicBoolean callInitOnLoad = new AtomicBoolean(true);

    public static LPAPersistenceDelegate createInstance(Persistence newPersistence) {
        return new LPAPersistenceDelegate(newPersistence);
    }

    public static LPAPersistenceDelegate createInstance(DatabasePersistence persistence) {
        LPAPersistenceDelegate delegate = new LPAPersistenceDelegate(new UnsafePersistenceWrapper(persistence, UnsafePersistenceWrapper.LOG_AND_THROW));
        persistence.initialize(delegate);
        return delegate;
    }

    private LPAPersistenceDelegate(Persistence newPersistence) {
        this.persistence = newPersistence;
    }

    @Override
    public boolean isHeadOffice() {
        return false;
    }

    @Override
    public void delete(long id, Class<? extends PersistentObjectI> toDelete) {
        PersistentObjDescriptor<? extends PersistentObjectI> descriptor = new PersistentObjDescriptor<PersistentObjectI>(id, toDelete);
        this.getPersistence().delete(descriptor);
    }

    @Override
    public <T extends PersistentObjectI> List<T> getObjectList(Class<T> type, String query, Object[] params, SessionI session) {
        List<T> objectList = this.getPersistence().getObjectList(type, query, params, session);
        if (!PersistentSummaryObject.class.isAssignableFrom(type) && PersistentObject.class.isAssignableFrom(type)) {
            for (PersistentObject obj : objectList) {
                if (obj.getLastSavedSnapshot() != null) {
                    CacheManager.getInstance().cacheFreshObject(obj);
                    continue;
                }
                CacheManager.getInstance().cacheObject(obj);
            }
        }
        return objectList;
    }

    @Override
    public Long save(PersistentObject toSave) {
        ExportableObject expObject;
        PersistentObject saveObject = toSave;
        PersistentObjectSnapshot snapshot = saveObject.getSnapshot();
        if (snapshot.equals(saveObject.getLastSavedSnapshot())) {
            return null;
        }
        saveObject.setLastSavedSnapshot(snapshot);
        long id = this.getPersistence().saveOrUpdate(snapshot);
        if (!saveObject.isPersistent()) {
            PersistenceManager.setID(saveObject, id);
        } else {
            this.incrementVersion(toSave);
        }
        snapshot.add(PersistentObject.Properties.ID, id);
        if (saveObject instanceof ExportableObject && this.isSettingMasterIdApplicable() && ((expObject = (ExportableObject)((Object)saveObject)).getMasterId() == null || expObject.getMasterId().equals(0L))) {
            this.generateObjectMasterID(expObject, snapshot);
        }
        CacheManager.getInstance().cacheFreshObject(saveObject);
        return saveObject.getID();
    }

    private void generateObjectMasterID(ExportableObject expObject, PersistentObjectSnapshot snapshot) {
        Long masterId = expObject.getID() + 10000L;
        expObject.setMasterId(masterId);
        snapshot.add(expObject.getProperties().getProperty("masterId"), masterId);
        this.getPersistence().saveOrUpdate(snapshot);
    }

    private boolean isSettingMasterIdApplicable() {
        HOConfig hoConf = HOConfig.getInstance();
        if (hoConf == null || hoConf.isEnabled()) {
            return false;
        }
        return hoConf.isMenuMasterSite();
    }

    private void incrementVersion(PersistentObject saveObject) {
        saveObject.setVersion(saveObject.getVersion() + 1);
    }

    @Override
    public PersistentList createList(PropertiedObject.Property property) {
        PersistentList toReturn = null;
        try {
            ClassMap map = this.getClassMap(property.getOwner());
            toReturn = map.createList(property);
        }
        catch (Exception ex) {
            throw new PersistenceException("Could not create list for : " + property, ex);
        }
        return toReturn;
    }

    @Override
    public PersistentWriteableList createWriteableList(PropertiedObject.Property property) {
        PersistentWriteableList toReturn = null;
        try {
            ClassMap map = this.getClassMap(property.getOwner());
            toReturn = (PersistentWriteableList)map.createList(property);
        }
        catch (ClassCastException ex) {
            throw new PersistenceException("Attempt to create writeable list for non-writeable property");
        }
        catch (Exception ex) {
            throw new PersistenceException("Could not create list for : " + property, ex);
        }
        return toReturn;
    }

    public Reference createReference(PropertiedObject.Property property) {
        Reference toReturn;
        try {
            ClassMap map = this.getClassMap(property.getOwner());
            toReturn = map.createReference(property);
        }
        catch (Exception ex) {
            throw new PersistenceException("Could not create reference for :" + property, ex);
        }
        return toReturn;
    }

    public String getClassTable(Class type) {
        return this.persistence.getClassTable(type);
    }

    @Override
    public String getDiscriminatorColumn(Class type) {
        return this.persistence.getDiscriminatorColumn(type);
    }

    @Override
    public String getDiscriminatorValue(Class type) {
        return this.persistence.getDiscriminatorValue(type);
    }

    @Override
    public String getPropertyColumn(PropertiedObject.Property property) {
        return this.persistence.getPropertyColumn(property);
    }

    @Override
    public String getPropertyTable(PropertiedObject.Property property) {
        return this.persistence.getPropertyTable(property);
    }

    @Override
    public <T extends PersistentObjectI> boolean classSupportsQueries(Class<T> type) {
        if (this.hasClassMap(type)) {
            ClassMap map = this.getClassMap(type);
            return map.supportsQueries();
        }
        return false;
    }

    public void registerMappings(Collection allMappings) {
        Iterator it = allMappings.iterator();
        while (it.hasNext()) {
            this.registerMapping((ClassMap)it.next());
        }
    }

    public void registerMapping(ClassMap toAdd) {
        this.mappings.put(toAdd.getTypeClass(), toAdd);
    }

    @Override
    public ClassMap getClassMap(Class type) throws IllegalArgumentException {
        if (this.mappings.size() == 0) {
            throw new IllegalStateException("Call to getClassMap before mappings initialized.");
        }
        if (!this.mappings.containsKey(type)) {
            IllegalArgumentException e = new IllegalArgumentException("No mapping defined for type " + type);
            OrderMateLog.LOG.error("No mapping defined for type " + type.getName(), (Throwable)e);
            throw e;
        }
        return this.mappings.get(type);
    }

    @Override
    public boolean hasClassMap(Class type) {
        return this.mappings.containsKey(type);
    }

    @Override
    public PersistentObject createFromSnapShot(PersistentObjectSnapshot snapShot) {
        PersistentObject persistentObj;
        block5: {
            persistentObj = null;
            if (snapShot == null) {
                throw new IllegalArgumentException("Snap shot should not be null");
            }
            try {
                persistentObj = (PersistentObject)snapShot.getObjectType().newInstance();
                persistentObj.setLastSavedSnapshot(snapShot);
                ClassMap classMap = this.getClassMap(snapShot.getObjectType());
                PropertyMapping[] propMappings = classMap.getPropertyMappings();
                for (int index = 0; index < propMappings.length; ++index) {
                    PropertyMapping currentMapping = propMappings[index];
                    Object value = currentMapping.getDBValueFromSnapshot(snapShot);
                    currentMapping.setObjectFieldFromDBValue(persistentObj, value);
                }
                ListMapping[] listMappings = classMap.getListMappings();
                for (int index = 0; index < listMappings.length; ++index) {
                    listMappings[index].setOwnerOnList(persistentObj);
                }
            }
            catch (Exception e) {
                OrderMateLog.LOG.error("Could not instantiate " + snapShot.getObjectType(), (Throwable)e);
                if (!Config.isDebuging()) break block5;
                throw new RuntimeException("Could not instantiate " + snapShot.getObjectType(), e);
            }
        }
        return persistentObj;
    }

    @Override
    public <T extends PersistentObject> void update(T toUpdate, PropertiedObject.Property<?>[] properties) {
        T updateObject = toUpdate;
        PersistentObjectSnapshot snapshot = updateObject.getSnapshot();
        this.getPersistence().update(snapshot, properties);
        CacheManager.getInstance().invalidateObject(new PersistentObjDescriptor(updateObject));
    }

    @Override
    public <T extends PersistentObject> T preload(PersistentObjDescriptor<T> toPreload, List<PropertiedObject.Property<?>[]> propsToExpand) {
        return (T)((PersistentObject)this.getPersistence().runSync(LPAPersistenceDelegate.getPreloader(toPreload, propsToExpand)));
    }

    private static <T extends PersistentObject> Executable<T> getPreloader(final PersistentObjDescriptor<T> toPreload, final List<PropertiedObject.Property<?>[]> propsToExpand) {
        return new Executable<T>(){

            @Override
            public T execute() {
                PersistenceDelegate delegate = PersistenceManager.getPersistenceDelegate();
                return PersistenceDelegate.PreloadHelper.preload(delegate, toPreload, propsToExpand);
            }
        };
    }

    @Override
    public <T extends PersistentObject> T preload(T toPreload) {
        if (toPreload == null) {
            return null;
        }
        if (!toPreload.isPersistent()) {
            if (Config.isDebuging()) {
                throw new IllegalArgumentException("Cannot preload an object not in the DB");
            }
            OrderMateLog.LOG.warn("Cannot preload object that is not persisted. " + toPreload, (Throwable)new IllegalArgumentException());
            return toPreload;
        }
        Object timer = null;
        PersistentObject newCopy = this.getPersistence().preload(toPreload.getObjectType(), toPreload.getID());
        CacheManager.getInstance().cacheObject(newCopy.getLastSavedSnapshot());
        return (T)newCopy;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    @Override
    public <T extends PersistentObject> T getByID(long ID, Class<T> type) {
        return this.getByID(ID, type, null);
    }

    @Override
    public <T extends PersistentObject> T getByID(long ID, Class<T> type, SessionI session) {
        List<T> objectList = this.getObjectList(type, this.createIDQuery(type, this.getPersistence()), new Object[]{ID}, session);
        if (objectList.isEmpty()) {
            return null;
        }
        return (T)((PersistentObject)objectList.get(0));
    }

    private String createIDQuery(Class type, Persistence persist) {
        String table = persist.getClassTable(type);
        String idCol = persist.getPropertyColumn(new PropertiedObject.Property((Class<? extends PropertiedObject>)type, PersistentObject.Properties.ID));
        StringBuilder SB = new StringBuilder("SELECT ");
        SB.append(table).append(".* FROM ").append(table).append(" WHERE ").append(idCol).append(" = ?");
        return SB.toString();
    }

    @Override
    public <T extends PersistentObjectI> List<T> refreshList(List<T> persistentObjects, Class<T> objType) {
        ArrayList<PersistentObjectI> cachedObjects = new ArrayList<PersistentObjectI>(persistentObjects.size());
        ArrayList<T> notFoundObjs = new ArrayList<T>(persistentObjects);
        for (PersistentObjectI nextObj : persistentObjects) {
            PersistentObjectI foundObj = CacheManager.getInstance().retrieveObject(nextObj.getID(), nextObj.getObjectType());
            if (foundObj == null) continue;
            cachedObjects.add(foundObj);
            notFoundObjs.remove(foundObj);
        }
        if (notFoundObjs.size() > 0) {
            List<T> reaquiredObjs = PersistenceManager.getObjectList(objType, Query.select(objType).wherePropertyIn(new PropertiedObject.Property(objType, PersistentObject.Properties.ID), notFoundObjs).toString(), PersistenceManager.EMPTY_OBJECT_ARRAY);
            cachedObjects.addAll(reaquiredObjs);
        }
        return cachedObjects;
    }

    @Override
    public <T extends PersistentObject> boolean hasChanged(T toCheck) {
        T checkObject = toCheck;
        if (checkObject.isPersistent()) {
            PersistentObjectSnapshot snapshot = checkObject.getSnapshot();
            return this.getPersistence().hasChanged(snapshot);
        }
        return true;
    }

    public Object runSync(Executable exec) {
        return this.persistence.runSync(exec);
    }

    @Override
    public PropertiedObject.Property getOwnerProperty(PropertiedObject.Property prop) {
        if (!prop.isList()) {
            throw new IllegalArgumentException("Property should be an FKList property");
        }
        PersistentList list = null;
        try {
            list = this.createList(prop);
        }
        catch (Exception e1) {
            throw new RuntimeException("Should be able to create list from an FKList prop " + prop, e1);
        }
        if (list != null && list instanceof FKList) {
            FKList fkList = (FKList)list;
            return fkList.getLinkBack();
        }
        throw new RuntimeException((list != null ? list.getClass() : null) + " was not an fkList");
    }

    @Override
    public Map<String, ?> getPropertyMetadata(PropertiedObject.Property prop) {
        return this.persistence.getPropertyMetadata(prop);
    }

    @Override
    public <T extends PersistentObject> PersistentList<T> createQueryList(Class<T> objectType, String query) {
        return QueryList.createQueryList(objectType, query);
    }

    @Override
    public <T extends PersistentObject> PersistentList<T> createQueryList(Class<T> objectType, ObjectQuery query) {
        return QueryList.createQueryList(objectType, query);
    }

    @Override
    public Object[][] executeQuery(String sql, Object[] params) {
        return this.persistence.executeQuery(sql, params);
    }

    @Override
    public long executeInsert(String sql, Object[] params) {
        return this.persistence.executeInsert(sql, params);
    }

    @Override
    public void executeUpdate(String sql, Object[] params) {
        this.persistence.executeUpdate(sql, params);
    }

    @Override
    public ComponentFactory createComponentFactory() {
        return this;
    }

    @Override
    public PersistenceMetaData createMetaData() {
        return this;
    }

    @Override
    public boolean usesSnapshot() {
        return true;
    }

    public void setCallInitOnLoad(boolean callInit) {
        this.callInitOnLoad.set(callInit);
    }

    public boolean isCallInitOnLoad() {
        return this.callInitOnLoad.get();
    }

    @Override
    public <T extends PersistentObjectI> T getObject(Class<T> type, String query, Object[] params, SessionI session) {
        List<T> objects = this.getObjectList(type, query, params, session);
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        return (T)((PersistentObjectI)objects.get(0));
    }
}

