/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ReferenceMapping;
import au.com.ordermate.util.MathsUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;

public class MappingUtils {
    public static String getColForProperty(PropertiedObject.Property property, ColumnPropertyMapping[] columnMaps) throws IllegalArgumentException {
        String col = null;
        for (int i = 0; i < columnMaps.length; ++i) {
            ColumnPropertyMapping map = columnMaps[i];
            if (!map.getProperty().equals(property)) continue;
            col = map.getCol();
            break;
        }
        if (col == null) {
            throw new IllegalArgumentException("Cannot find column for property " + property + " in class " + property.getOwner());
        }
        return col;
    }

    public static boolean equalsNullSafe(Object object1, Object object2) {
        boolean equals = false;
        if (object1 == null && object2 == null) {
            equals = true;
        } else if (object1 == null || object2 == null) {
            equals = false;
        } else if (object1 instanceof Number && object2 instanceof Number && !object1.equals(object2)) {
            double number1 = ((Number)object1).doubleValue();
            double number2 = ((Number)object2).doubleValue();
            equals = MathsUtils.approxEquals(number1, number2);
        } else if (object1 instanceof Timestamp && object2 instanceof Timestamp) {
            Timestamp timestamp1 = (Timestamp)object1;
            Timestamp timestamp2 = (Timestamp)object2;
            Date truncated1 = DateUtils.truncate((Date)timestamp1, (int)12);
            Date truncated2 = DateUtils.truncate((Date)timestamp2, (int)12);
            equals = truncated1.equals(truncated2);
        } else {
            equals = object1 instanceof Date && object2 instanceof Date && !object1.equals(object2) ? object1.toString().equals(object2.toString()) : object1.equals(object2);
        }
        return equals;
    }

    public static PersistentList createList(PropertiedObject.Property property, ListMapping[] mappings) throws Exception {
        ListMapping mapping = null;
        for (int i = 0; i < mappings.length; ++i) {
            if (!mappings[i].getProperty().equals(property)) continue;
            mapping = mappings[i];
            break;
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Cannot find mapping for " + property);
        }
        PersistentList toReturn = mapping.getPrototype().clone();
        return toReturn;
    }

    public static Reference createReference(PropertiedObject.Property property, ColumnPropertyMapping[] mappings) throws Exception {
        ReferenceMapping mapping = null;
        for (int i = 0; i < mappings.length; ++i) {
            if (!(mappings[i] instanceof ReferenceMapping) || !mappings[i].getProperty().equals(property)) continue;
            mapping = (ReferenceMapping)mappings[i];
            break;
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Cannot find reference mapping for " + property);
        }
        return mapping.createReference();
    }

    public static Map<String, ?> getMetadataForProperty(PropertiedObject.Property property, ColumnPropertyMapping[] columnMaps) throws IllegalArgumentException {
        Map<String, ?> metadata = null;
        for (int i = 0; i < columnMaps.length; ++i) {
            ColumnPropertyMapping map = columnMaps[i];
            if (!map.getProperty().equals(property)) continue;
            metadata = map.getMetadata();
            break;
        }
        return metadata;
    }
}

