/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.persistence.PersistentObjectSnapshotDiff;
import java.util.ArrayList;
import java.util.List;
import ordermate.observers.PersistenceChangeListener;

class PersistInterceptorGWWorker
implements GatewayProcessor<PersistentObjectSnapshotDiff> {
    private final List<PersistenceChangeListener> listenersRegistry = new ArrayList<PersistenceChangeListener>();

    PersistInterceptorGWWorker() {
    }

    @Override
    public boolean processIncoming(PersistentObjectSnapshotDiff toProcess) {
        boolean allProcessed = true;
        for (PersistenceChangeListener changeListener : this.listenersRegistry) {
            allProcessed = changeListener.fireAction(toProcess) && allProcessed;
        }
        return allProcessed;
    }

    public void registerListener(PersistenceChangeListener listener) {
        boolean registered = false;
        for (PersistenceChangeListener existing : this.listenersRegistry) {
            if (!existing.equals(listener)) continue;
            registered = true;
            break;
        }
        if (!registered) {
            this.listenersRegistry.add(listener);
        }
    }

    public void deRegisterListener(PersistenceChangeListener listener) {
        this.listenersRegistry.remove(listener);
    }

    public boolean isRelevantClass(Class clazz) {
        for (PersistenceChangeListener listener : this.listenersRegistry) {
            if (!listener.isRelevantClass(clazz)) continue;
            return true;
        }
        return false;
    }
}

