/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.persistence.database.AbstractColumnClassMap;
import au.com.ordermate.persistence.database.AbstractQueryableColumnClassMap;
import au.com.ordermate.persistence.database.AbstractSuperClassMap;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.LPAPersistenceDelegate;
import au.com.ordermate.persistence.database.MappingUtils;
import au.com.ordermate.persistence.database.SubClassMap;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.ListMapping;
import au.com.ordermate.persistence.database.columnpropertymap.PropertyMapping;
import au.com.ordermate.persistence.database.idgeneration.IDGenerationStrategy;
import au.com.ordermate.sql.SQL;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.database.DBConnectionInterface;

public class SubClassMapAdapter
implements SubClassMap {
    private final String insertSQL;
    private final String discrimValue;
    private final AbstractSuperClassMap superClassMap;
    private final AbstractQueryableColumnClassMap wrappedClassMap;
    private final PropertiedObject.Property[] writableProps;

    public SubClassMapAdapter(String discrimVal, AbstractSuperClassMap superMap, AbstractQueryableColumnClassMap wrappedMap) {
        this.discrimValue = discrimVal;
        this.superClassMap = superMap;
        this.wrappedClassMap = wrappedMap;
        this.insertSQL = SQL.insert(this.getTable(), SubClassMap.SubClassMapHelper.getCols(this));
        if (!this.superClassMap.getTable().equals(this.wrappedClassMap.getTable())) {
            throw new IllegalArgumentException("Superclass map and wrapped subclass map should point to the same table : " + this.superClassMap.getTable() + " - " + this.wrappedClassMap.getTable());
        }
        this.superClassMap.addSubClassMap(this, discrimVal);
        this.writableProps = AbstractQueryableColumnClassMap.getWritableProperties(this);
    }

    @Override
    public String getTable() {
        return this.superClassMap.getTable();
    }

    @Override
    public long insertObject(PersistentObjectSnapshot toInsert, DBConnectionInterface conn) throws Exception {
        return SubClassMap.SubClassMapHelper.insert(this, toInsert, this.insertSQL, conn);
    }

    @Override
    public void updateObject(PersistentObjectSnapshot<?> toUpdate, PropertiedObject.Property[] properties, DBConnectionInterface conn) throws Exception {
        SubClassMap.SubClassMapHelper.updateObject(this, toUpdate, properties, conn);
    }

    @Override
    public void deleteObject(PersistentObjDescriptor toDelete, DBConnectionInterface conn) throws Exception {
        this.wrappedClassMap.deleteObject(toDelete, conn);
    }

    @Override
    public boolean hasChanged(PersistentObjectSnapshot toCheck, DBConnectionInterface conn) throws Exception {
        return this.wrappedClassMap.hasChanged(toCheck, conn);
    }

    @Override
    public ClassMap getLockableClassMap() {
        return this.superClassMap.getLockableClassMap();
    }

    @Override
    public Class getTypeClass() {
        return this.wrappedClassMap.getTypeClass();
    }

    @Override
    public PersistentList createList(PropertiedObject.Property property) throws Exception {
        return MappingUtils.createList(property, this.getListMappings());
    }

    @Override
    public Reference createReference(PropertiedObject.Property property) throws Exception {
        return MappingUtils.createReference(property, this.getMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getObjectList(String query, Object[] params, DBConnectionInterface conn) throws Exception {
        ResultSet rs = conn.executeQuery(query, params);
        try {
            ArrayList<PersistentObjectI> objects = new ArrayList<PersistentObjectI>();
            int objectCount = 0;
            while (rs.next()) {
                PersistentObjectI created = this.createFromResultSet(rs);
                objects.add(created);
                if (++objectCount % 1000 != 0) continue;
                Thread.yield();
            }
            ArrayList<PersistentObjectI> arrayList = objects;
            return arrayList;
        }
        finally {
            conn.release(rs);
        }
    }

    @Override
    public void preload(PersistentObjectI toPreload) {
        this.wrappedClassMap.preload(toPreload);
    }

    @Override
    public PropertyMapping[] getPropertyMappings() {
        PropertyMapping[] wrappedClassPropMaps = this.wrappedClassMap.getPropertyMappings();
        PropertyMapping[] superClassPropMaps = this.superClassMap.getPropertyMappings();
        PropertyMapping[] propMaps = new PropertyMapping[wrappedClassPropMaps.length + superClassPropMaps.length];
        System.arraycopy(wrappedClassPropMaps, 0, propMaps, 0, wrappedClassPropMaps.length);
        System.arraycopy(superClassPropMaps, 0, propMaps, wrappedClassPropMaps.length, superClassPropMaps.length);
        return propMaps;
    }

    @Override
    public ListMapping[] getListMappings() {
        ListMapping[] subArray = this.wrappedClassMap.getListMappings();
        ListMapping[] superArray = this.superClassMap.getSuperClassListMappings();
        int newLength = subArray.length + superArray.length;
        Object[] combinedArrays = (Object[])Array.newInstance(ListMapping.class, newLength);
        System.arraycopy(subArray, 0, combinedArrays, 0, subArray.length);
        System.arraycopy(superArray, 0, combinedArrays, subArray.length, superArray.length);
        return (ListMapping[])combinedArrays;
    }

    @Override
    public boolean isVersioned() {
        return this.wrappedClassMap.isVersioned();
    }

    @Override
    public boolean supportsQueries() {
        return true;
    }

    @Override
    public String getColumn(PropertiedObject.Property property) {
        return MappingUtils.getColForProperty(property, this.getMappings());
    }

    @Override
    public Map<String, ?> getMetadata(PropertiedObject.Property property) {
        return MappingUtils.getMetadataForProperty(property, this.getMappings());
    }

    @Override
    public PersistentObjectI createFromResultSet(ResultSet rs) throws Exception {
        String typeVal = SQL.supportsTableNameColumnSelection() ? rs.getString(this.getTable() + "." + this.getSuperClassMap().getDiscriminatorColumn()) : rs.getString(this.getSuperClassMap().getDiscriminatorColumn());
        if (!typeVal.equalsIgnoreCase(this.getDiscriminatorValue())) {
            throw new IllegalArgumentException("ResultSet contains data for object of type " + typeVal + " however this mapping deals with objects of type " + this.getDiscriminatorValue());
        }
        PersistentObjectI retval = this.wrappedClassMap.createRawObject();
        AbstractColumnClassMap.applyMappedProperties(this, this.getMappings(), this.getListMappings(), retval, rs);
        if (retval instanceof PersistentObject && ((LPAPersistenceDelegate)PersistenceManager.getPersistenceDelegate()).isCallInitOnLoad()) {
            ((PersistentObject)retval).init();
        }
        return retval;
    }

    @Override
    public String getDiscriminatorValue() {
        return this.discrimValue;
    }

    @Override
    public AbstractSuperClassMap getSuperClassMap() {
        return this.superClassMap;
    }

    @Override
    public ColumnPropertyMapping[] getMappings() {
        ColumnPropertyMapping[] wrappedClassMappings = this.wrappedClassMap.getMappings();
        ColumnPropertyMapping[] superMappings = this.superClassMap.getSuperClassMappings();
        ColumnPropertyMapping[] maps = new ColumnPropertyMapping[wrappedClassMappings.length + superMappings.length];
        System.arraycopy(wrappedClassMappings, 0, maps, 0, wrappedClassMappings.length);
        System.arraycopy(superMappings, 0, maps, wrappedClassMappings.length, superMappings.length);
        return maps;
    }

    @Override
    public PropertiedObject.Property[] getWritableProperties() {
        return this.writableProps;
    }

    @Override
    public IDGenerationStrategy getIdGenerationStrategy() {
        return this.wrappedClassMap.getIdGenerationStrategy();
    }
}

