/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.sql.SQL;
import java.sql.ResultSet;

public abstract class AbstractByteArrayMapping<T>
extends InstanceVarMapping {
    public AbstractByteArrayMapping(PropertiedObject.Property prop) {
        super(prop);
    }

    public AbstractByteArrayMapping(PropertiedObject.Property prop, String newCol) {
        super(prop, newCol);
    }

    public AbstractByteArrayMapping(PropertiedObject.Property prop, String newCol, String newTable) {
        super(prop, newCol, newTable);
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        if (dbValue == null) {
            super.setObjectFieldFromDBValue(owner, null);
        } else {
            byte[] bytes = this.convertObjectToByteArray(dbValue);
            super.setObjectFieldFromDBValue(owner, bytes);
        }
    }

    public T getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        byte[] bytes = (byte[])super.getDBValueFromSnapshot(snapshot);
        if (bytes == null) {
            return null;
        }
        return this.convertByteArrayToObject(bytes);
    }

    public byte[] getFromResultSet(ResultSet rs) throws Exception {
        String colName = SQL.supportsTableNameColumnSelection() && this.getTable() != null ? this.getTable() + "." + this.getCol() : this.getCol();
        if (rs.getObject(colName) != null) {
            return rs.getBytes(colName);
        }
        return null;
    }

    protected abstract T convertByteArrayToObject(byte[] var1);

    protected abstract byte[] convertObjectToByteArray(T var1);
}

