/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.MappingUtils;
import au.com.ordermate.persistence.database.columnpropertymap.ColumnPropertyMapping;
import au.com.ordermate.persistence.database.columnpropertymap.RowPropertyMapping;
import au.com.ordermate.reflect.ReflectUtils;
import au.com.ordermate.sql.SQL;
import java.sql.ResultSet;

public abstract class AbstractPropertyMapping
implements ColumnPropertyMapping,
RowPropertyMapping {
    private PropertiedObject.Property property;
    private String col;
    private String dbKey;
    private String table = "";
    private String tableColumnName;

    public AbstractPropertyMapping(PropertiedObject.Property name) {
        this(name, name.getName());
    }

    public AbstractPropertyMapping(PropertiedObject.Property newProperty, String identifier) {
        this.property = newProperty;
        this.col = identifier;
        this.dbKey = identifier;
    }

    @Override
    public final String getCol() {
        return this.col;
    }

    @Override
    public final void setCol(String column) {
        this.col = column;
        this.tableColumnName = null;
    }

    @Override
    public final String getTable() {
        return this.table;
    }

    @Override
    public final void setTable(String newTable) {
        this.table = newTable;
        this.tableColumnName = null;
    }

    @Override
    public final String getDbKey() {
        return this.dbKey;
    }

    @Override
    public Object getFromResultSet(ResultSet rs) throws Exception {
        return rs.getObject(this.getTableColumnName());
    }

    protected String getTableColumnName() {
        if (this.tableColumnName == null) {
            this.tableColumnName = SQL.supportsTableNameColumnSelection() && this.getTable() != null ? this.getTable() + "." + this.getCol() : this.getCol();
        }
        return this.tableColumnName;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public final PropertiedObject.Property getProperty() {
        return this.property;
    }

    @Override
    public boolean useInHasChanged() {
        return true;
    }

    public String toString() {
        return ReflectUtils.getShortClassName(this.getClass()) + "[" + this.property + " : " + this.col + "]";
    }

    @Override
    public boolean hasChanged(Object objectValue, Object dbValue) {
        return this.useInHasChanged() && !MappingUtils.equalsNullSafe(objectValue, dbValue);
    }
}

