/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.util.GuiUtils;
import java.awt.Color;
import java.sql.ResultSet;

public class ColorMapping
extends InstanceVarMapping {
    public ColorMapping(PropertiedObject.Property name) {
        super(name);
    }

    public ColorMapping(PropertiedObject.Property newProperty, String newCol) {
        super(newProperty, newCol);
    }

    public ColorMapping(PropertiedObject.Property newProperty, String newCol, String table) {
        super(newProperty, newCol, table);
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        if (dbValue == null) {
            super.setObjectFieldFromDBValue(owner, null);
        } else {
            if (!(dbValue instanceof String)) {
                throw new IllegalArgumentException("ColorMapping does not work with DB columns which are not Strings.  Got object of type " + dbValue.getClass());
            }
            String stringVal = (String)dbValue;
            Color color = GuiUtils.makeColor(stringVal);
            super.setObjectFieldFromDBValue(owner, color);
        }
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        Color color = (Color)super.getDBValueFromSnapshot(snapshot);
        if (color == null) {
            return null;
        }
        String stringVal = GuiUtils.colorAsString(color);
        return stringVal;
    }

    @Override
    public Object getFromResultSet(ResultSet rs) throws Exception {
        String colName = SQL.supportsTableNameColumnSelection() && this.getTable() != null ? this.getTable() + "." + this.getCol() : this.getCol();
        return rs.getString(colName);
    }
}

