/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.util.DateTimeUtils;
import java.sql.ResultSet;
import java.sql.Time;
import java.util.Calendar;

public class DurationMapping
extends InstanceVarMapping {
    public DurationMapping(PropertiedObject.Property name, String colName) {
        super(name, colName);
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        Long duration = (Long)super.getDBValueFromSnapshot(snapshot);
        if (duration == null) {
            return null;
        }
        return DateTimeUtils.longDurationToTime(duration);
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        if (dbValue == null) {
            super.setObjectFieldFromDBValue(owner, null);
            return;
        }
        if (dbValue instanceof Time) {
            Time time = (Time)dbValue;
            Long transformedValue = DateTimeUtils.timeDurationToLong(time);
            super.setObjectFieldFromDBValue(owner, transformedValue);
        } else if (dbValue instanceof Long) {
            super.setObjectFieldFromDBValue(owner, dbValue);
        } else {
            throw new IllegalArgumentException("Expected sql time value but got : " + dbValue.getClass());
        }
    }

    @Override
    public Object getFromResultSet(ResultSet rs) throws Exception {
        Object obj;
        String colName = SQL.supportsTableNameColumnSelection() && this.getTable() != null ? this.getTable() + "." + this.getCol() : this.getCol();
        if (rs.getObject(colName) != null && (obj = rs.getObject(colName)) instanceof Time) {
            Long timeInMilli = ((Time)obj).getTime() + (long)Calendar.getInstance().getTimeZone().getRawOffset();
            if (timeInMilli < 1000L) {
                return new Long(86400000L);
            }
            return timeInMilli;
        }
        return null;
    }
}

