/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.util.SecurityUtils;

public class EncryptedMapping
extends InstanceVarMapping {
    private static final String scramble = "_87331";
    private final SecurityUtils securityUtil;

    public EncryptedMapping(PropertiedObject.Property name) {
        super(name);
        this.securityUtil = new SecurityUtils("$" + name.getOwner().getSimpleName() + scramble);
    }

    public EncryptedMapping(PropertiedObject.Property name, String column) {
        super(name, column);
        this.securityUtil = new SecurityUtils("$" + name.getOwner().getSimpleName() + scramble);
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        String hashValue = String.valueOf(dbValue);
        String originalValue = this.securityUtil.decrypt(hashValue);
        super.setObjectFieldFromDBValue(owner, originalValue);
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        Object value = super.getDBValueFromSnapshot(snapshot);
        return this.securityUtil.encrypt(value);
    }
}

