/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.AbstractByteArrayMapping;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import ordermate.OrderMate;

public class ImageMapping
extends AbstractByteArrayMapping<BufferedImage> {
    private String formatType;

    public ImageMapping(PropertiedObject.Property prop, String imageFormatType) {
        super(prop);
        this.formatType = imageFormatType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BufferedImage convertByteArrayToObject(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BufferedImage image = null;
        try {
            image = ImageIO.read(bais);
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Could not read in the image from the database.", (Throwable)ex);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException ex2) {
                OrderMate.LOG.warn("Could not close off the image stream.", (Throwable)ex2);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] convertObjectToByteArray(BufferedImage toConvert) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)toConvert, this.formatType, bout);
            bout.flush();
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Error writing image to byte[]", (Throwable)ex);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException ex2) {
                OrderMate.LOG.warn("Error closing off image byte array.", (Throwable)ex2);
            }
        }
        return bout.toByteArray();
    }
}

