/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.AbstractPropertyMapping;
import au.com.ordermate.reflect.FieldUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;

public class InstanceVarMapping
extends AbstractPropertyMapping {
    private Class expectedObjectClass = null;
    private Field field = null;
    private boolean readOnly = false;

    public InstanceVarMapping(PropertiedObject.Property name) {
        super(name);
    }

    public InstanceVarMapping(PropertiedObject.Property newProperty, String newCol) {
        super(newProperty, newCol);
    }

    public InstanceVarMapping(PropertiedObject.Property newProperty, String newCol, boolean isReadOnly) {
        super(newProperty, newCol);
        this.readOnly = isReadOnly;
    }

    public InstanceVarMapping(PropertiedObject.Property newProperty, String newCol, String newTable) {
        this(newProperty, newCol, newTable, true);
    }

    public InstanceVarMapping(PropertiedObject.Property newProperty, String newCol, String newTable, boolean isReadOnly) {
        super(newProperty, newCol);
        this.setTable(newTable);
        this.readOnly = isReadOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        if (this.expectedObjectClass == null) {
            this.expectedObjectClass = owner.getClass();
        }
        this.getField().set(owner, dbValue);
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        if (this.expectedObjectClass == null) {
            this.expectedObjectClass = snapshot.getObjectType();
        }
        return snapshot.get(this.getProperty());
    }

    private Field getField() throws Exception {
        if (this.field == null) {
            this.field = FieldUtils.getField(this.expectedObjectClass, this.getProperty().getName());
        }
        return this.field;
    }

    @Override
    public boolean isVersionProperty() {
        return false;
    }

    @Override
    public Map<String, ?> getMetadata() {
        return Collections.EMPTY_MAP;
    }
}

