/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Map;

public class PriceMapping
extends InstanceVarMapping {
    private double roundAmount;

    public PriceMapping(PropertiedObject.Property newProperty, double newRoundAmount) {
        super(newProperty);
        this.roundAmount = newRoundAmount;
    }

    public PriceMapping(PropertiedObject.Property newProperty, String newCol, double newRoundAmount) {
        super(newProperty, newCol);
        this.roundAmount = newRoundAmount;
    }

    public PriceMapping(PropertiedObject.Property newProperty, String newCol, String newTable, double newRoundAmount) {
        this(newProperty, newCol, newRoundAmount);
        this.setTable(newTable);
    }

    @Override
    public Object getFromResultSet(ResultSet rs) throws Exception {
        String colName = this.getTableColumnName();
        if (rs.getObject(colName) != null) {
            return new Double(rs.getDouble(colName));
        }
        return null;
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        if (dbValue != null && !(dbValue instanceof Number)) {
            throw new IllegalArgumentException("PriceMapping does not work with DB columns which are not doubles");
        }
        Number doubleVal = (Number)dbValue;
        Price priceVal = doubleVal != null ? new Price(doubleVal, this.roundAmount) : null;
        super.setObjectFieldFromDBValue(owner, priceVal);
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        Price price = (Price)super.getDBValueFromSnapshot(snapshot);
        return price != null ? new Double(price.doubleValue()) : null;
    }

    @Override
    public boolean hasChanged(Object objectValue, Object dbValue) {
        if (!this.useInHasChanged() || objectValue == null && dbValue == null) {
            return false;
        }
        if (objectValue == null && dbValue != null || objectValue != null && dbValue == null) {
            return true;
        }
        return !new Price((Number)objectValue, this.roundAmount).equals(new Price((Number)dbValue, this.roundAmount));
    }

    public Map<String, ? extends Object> getMetadata() {
        return Collections.singletonMap("price rounding", this.roundAmount);
    }
}

