/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;

public class PropertyInstanceMapping
extends InstanceVarMapping {
    public PropertyInstanceMapping(PropertiedObject.Property<PropertiedObject.Property> property) {
        super(property);
    }

    public PropertyInstanceMapping(PropertiedObject.Property<PropertiedObject.Property> property, String column) {
        super(property, column);
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        if (!(dbValue instanceof String)) {
            throw new IllegalArgumentException("PropertyNameMapping only works with string fields");
        }
        String[] nameParts = ((String)dbValue).split(":");
        if (nameParts.length == 2) {
            try {
                Class<?> ownerClass = Class.forName(nameParts[0]);
                PersistentObject.Props properties = (PersistentObject.Props)ownerClass.getField("Properties").get(null);
                if (properties != null) {
                    super.setObjectFieldFromDBValue(owner, properties.getProperty(nameParts[1]));
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        super.setObjectFieldFromDBValue(owner, null);
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        PropertiedObject.Property property = (PropertiedObject.Property)super.getDBValueFromSnapshot(snapshot);
        return this.formatProperty(property);
    }

    public String formatProperty(PropertiedObject.Property property) {
        Class<PropertiedObject> theOwner;
        Class<PropertiedObject> clazz = theOwner = property != null ? property.getOwner() : null;
        if (theOwner != null) {
            return theOwner.getName() + ":" + property.getName();
        }
        return "";
    }
}

