/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import au.com.ordermate.persistence.reference.QueryReference;
import java.sql.ResultSet;

public class ReferenceMapping
extends InstanceVarMapping {
    private Reference prototype;
    private boolean sqlInitialised;
    private boolean useInHasChanged = true;

    public <T extends PersistentObjectI> ReferenceMapping(PropertiedObject.Property<T> newName, String newDbColumn, Reference<T> newPrototype, String tableName) {
        super(newName, newDbColumn, tableName);
        this.prototype = newPrototype;
    }

    public <T extends PersistentObjectI> ReferenceMapping(PropertiedObject.Property<T> newName, String newDbColumn, Reference<T> newPrototype) {
        super(newName, newDbColumn);
        this.prototype = newPrototype;
    }

    public <T extends PersistentObjectI> ReferenceMapping(PropertiedObject.Property<T> newName, String newDbColumn, boolean newUseInHasChanged, Reference<T> newPrototype) {
        super(newName, newDbColumn);
        this.prototype = newPrototype;
        this.useInHasChanged = newUseInHasChanged;
    }

    private Reference getPrototype() throws Exception {
        if (!this.sqlInitialised) {
            this.prototype.initSQL();
            this.sqlInitialised = true;
        }
        return this.prototype;
    }

    @Override
    public Object getFromResultSet(ResultSet rs) throws Exception {
        if (this.prototype.belongsToOwner()) {
            return super.getFromResultSet(rs);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object value) throws Exception {
        Long referenceID = null;
        if (!this.prototype.belongsToOwner()) {
            return;
        }
        if (value != null && !(value instanceof Number)) {
            if (!(value instanceof String)) throw new IllegalArgumentException("ReferenceMappings only work with columns of type integer or strings that can be parsed as Integers.  " + this.getCol() + " contains an object of type " + value.getClass());
            referenceID = Long.parseLong((String)value);
        } else {
            referenceID = value != null ? Long.valueOf(((Number)value).longValue()) : null;
        }
        Reference ref = (Reference)this.getPrototype().clone();
        super.setObjectFieldFromDBValue(owner, ref);
        ref.setObjectID(referenceID);
        ref.setOwner((PersistentObject)owner);
    }

    @Override
    public boolean useInHasChanged() {
        return this.prototype.belongsToOwner() && this.useInHasChanged;
    }

    public Reference createReference() throws Exception {
        return (Reference)this.getPrototype().clone();
    }

    public Class getReferenceType() {
        return this.prototype.getType();
    }

    public boolean isQueryReference() {
        return this.prototype instanceof QueryReference;
    }
}

