/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.persistence.database.columnpropertymap;

import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.database.columnpropertymap.InstanceVarMapping;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import ordermate.OrderMate;

public class SerializableMapping
extends InstanceVarMapping {
    public SerializableMapping(PropertiedObject.Property newProperty, String colName) {
        super(newProperty, colName);
    }

    @Override
    public void setObjectFieldFromDBValue(PersistentObjectI owner, Object dbValue) throws Exception {
        if (dbValue instanceof byte[]) {
            Object toSet = null;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream((byte[])dbValue);
                ObjectInputStream stream = new ObjectInputStream(bis);
                toSet = stream.readObject();
            }
            catch (Exception e) {
                OrderMate.LOG.error("SerializableMapping failed to read byte[] into object form!", (Throwable)e);
            }
            super.setObjectFieldFromDBValue(owner, toSet);
        } else if (dbValue instanceof Serializable) {
            super.setObjectFieldFromDBValue(owner, dbValue);
        } else if (dbValue != null) {
            throw new IllegalArgumentException("Expecting byte array but was " + dbValue.getClass());
        }
    }

    @Override
    public Object getDBValueFromSnapshot(PersistentObjectSnapshot snapshot) throws Exception {
        return super.getDBValueFromSnapshot(snapshot);
    }
}

